<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchOptions StructType
 * @subpackage Structs
 */
class SearchOptions extends AbstractStructBase
{
    /**
     * The DisplayStart
     * @var int
     */
    public $DisplayStart;
    /**
     * Constructor method for SearchOptions
     * @uses SearchOptions::setDisplayStart()
     * @param int $displayStart
     */
    public function __construct($displayStart = null)
    {
        $this
            ->setDisplayStart($displayStart);
    }
    /**
     * Get DisplayStart value
     * @return int|null
     */
    public function getDisplayStart()
    {
        return $this->DisplayStart;
    }
    /**
     * Set DisplayStart value
     * @param int $displayStart
     * @return \StructType\SearchOptions
     */
    public function setDisplayStart($displayStart = null)
    {
        // validation for constraint: int
        if (!is_null($displayStart) && !(is_int($displayStart) || ctype_digit($displayStart))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($displayStart, true), gettype($displayStart)), __LINE__);
        }
        $this->DisplayStart = $displayStart;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
