<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleOrderItems StructType
 * @subpackage Structs
 */
class SaleOrderItems extends AbstractStructBase
{
    /**
     * The SaleOrderItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\SaleOrderItem[]
     */
    public $SaleOrderItem;
    /**
     * Constructor method for SaleOrderItems
     * @uses SaleOrderItems::setSaleOrderItem()
     * @param \StructType\SaleOrderItem[] $saleOrderItem
     */
    public function __construct(array $saleOrderItem = array())
    {
        $this
            ->setSaleOrderItem($saleOrderItem);
    }
    /**
     * Get SaleOrderItem value
     * @return \StructType\SaleOrderItem[]|null
     */
    public function getSaleOrderItem()
    {
        return $this->SaleOrderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setSaleOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSaleOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSaleOrderItemForArrayConstraintsFromSetSaleOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $saleOrderItemsSaleOrderItemItem) {
            // validation for constraint: itemType
            if (!$saleOrderItemsSaleOrderItemItem instanceof \StructType\SaleOrderItem) {
                $invalidValues[] = is_object($saleOrderItemsSaleOrderItemItem) ? get_class($saleOrderItemsSaleOrderItemItem) : sprintf('%s(%s)', gettype($saleOrderItemsSaleOrderItemItem), var_export($saleOrderItemsSaleOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SaleOrderItem property can only contain items of type \StructType\SaleOrderItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SaleOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SaleOrderItem[] $saleOrderItem
     * @return \StructType\SaleOrderItems
     */
    public function setSaleOrderItem(array $saleOrderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($saleOrderItemArrayErrorMessage = self::validateSaleOrderItemForArrayConstraintsFromSetSaleOrderItem($saleOrderItem))) {
            throw new \InvalidArgumentException($saleOrderItemArrayErrorMessage, __LINE__);
        }
        $this->SaleOrderItem = $saleOrderItem;
        return $this;
    }
    /**
     * Add item to SaleOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SaleOrderItem $item
     * @return \StructType\SaleOrderItems
     */
    public function addToSaleOrderItem(\StructType\SaleOrderItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SaleOrderItem) {
            throw new \InvalidArgumentException(sprintf('The SaleOrderItem property can only contain items of type \StructType\SaleOrderItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SaleOrderItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaleOrderItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
