<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleOrderItemDTO StructType
 * @subpackage Structs
 */
class SaleOrderItemDTO extends AbstractStructBase
{
    /**
     * The SaleOrderCode
     * @var string
     */
    public $SaleOrderCode;
    /**
     * The SaleOrderItemCode
     * @var string
     */
    public $SaleOrderItemCode;
    /**
     * The SaleOrderItemStatus
     * @var string
     */
    public $SaleOrderItemStatus;
    /**
     * The ShippingPackageCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShippingPackageCode;
    /**
     * The ShippingPackageStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShippingPackageStatus;
    /**
     * The Created
     * @var string
     */
    public $Created;
    /**
     * Constructor method for SaleOrderItemDTO
     * @uses SaleOrderItemDTO::setSaleOrderCode()
     * @uses SaleOrderItemDTO::setSaleOrderItemCode()
     * @uses SaleOrderItemDTO::setSaleOrderItemStatus()
     * @uses SaleOrderItemDTO::setShippingPackageCode()
     * @uses SaleOrderItemDTO::setShippingPackageStatus()
     * @uses SaleOrderItemDTO::setCreated()
     * @param string $saleOrderCode
     * @param string $saleOrderItemCode
     * @param string $saleOrderItemStatus
     * @param string $shippingPackageCode
     * @param string $shippingPackageStatus
     * @param string $created
     */
    public function __construct($saleOrderCode = null, $saleOrderItemCode = null, $saleOrderItemStatus = null, $shippingPackageCode = null, $shippingPackageStatus = null, $created = null)
    {
        $this
            ->setSaleOrderCode($saleOrderCode)
            ->setSaleOrderItemCode($saleOrderItemCode)
            ->setSaleOrderItemStatus($saleOrderItemStatus)
            ->setShippingPackageCode($shippingPackageCode)
            ->setShippingPackageStatus($shippingPackageStatus)
            ->setCreated($created);
    }
    /**
     * Get SaleOrderCode value
     * @return string|null
     */
    public function getSaleOrderCode()
    {
        return $this->SaleOrderCode;
    }
    /**
     * Set SaleOrderCode value
     * @param string $saleOrderCode
     * @return \StructType\SaleOrderItemDTO
     */
    public function setSaleOrderCode($saleOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderCode) && !is_string($saleOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderCode, true), gettype($saleOrderCode)), __LINE__);
        }
        $this->SaleOrderCode = $saleOrderCode;
        return $this;
    }
    /**
     * Get SaleOrderItemCode value
     * @return string|null
     */
    public function getSaleOrderItemCode()
    {
        return $this->SaleOrderItemCode;
    }
    /**
     * Set SaleOrderItemCode value
     * @param string $saleOrderItemCode
     * @return \StructType\SaleOrderItemDTO
     */
    public function setSaleOrderItemCode($saleOrderItemCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderItemCode) && !is_string($saleOrderItemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderItemCode, true), gettype($saleOrderItemCode)), __LINE__);
        }
        $this->SaleOrderItemCode = $saleOrderItemCode;
        return $this;
    }
    /**
     * Get SaleOrderItemStatus value
     * @return string|null
     */
    public function getSaleOrderItemStatus()
    {
        return $this->SaleOrderItemStatus;
    }
    /**
     * Set SaleOrderItemStatus value
     * @param string $saleOrderItemStatus
     * @return \StructType\SaleOrderItemDTO
     */
    public function setSaleOrderItemStatus($saleOrderItemStatus = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderItemStatus) && !is_string($saleOrderItemStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderItemStatus, true), gettype($saleOrderItemStatus)), __LINE__);
        }
        $this->SaleOrderItemStatus = $saleOrderItemStatus;
        return $this;
    }
    /**
     * Get ShippingPackageCode value
     * @return string|null
     */
    public function getShippingPackageCode()
    {
        return $this->ShippingPackageCode;
    }
    /**
     * Set ShippingPackageCode value
     * @param string $shippingPackageCode
     * @return \StructType\SaleOrderItemDTO
     */
    public function setShippingPackageCode($shippingPackageCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingPackageCode) && !is_string($shippingPackageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingPackageCode, true), gettype($shippingPackageCode)), __LINE__);
        }
        $this->ShippingPackageCode = $shippingPackageCode;
        return $this;
    }
    /**
     * Get ShippingPackageStatus value
     * @return string|null
     */
    public function getShippingPackageStatus()
    {
        return $this->ShippingPackageStatus;
    }
    /**
     * Set ShippingPackageStatus value
     * @param string $shippingPackageStatus
     * @return \StructType\SaleOrderItemDTO
     */
    public function setShippingPackageStatus($shippingPackageStatus = null)
    {
        // validation for constraint: string
        if (!is_null($shippingPackageStatus) && !is_string($shippingPackageStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingPackageStatus, true), gettype($shippingPackageStatus)), __LINE__);
        }
        $this->ShippingPackageStatus = $shippingPackageStatus;
        return $this;
    }
    /**
     * Get Created value
     * @return string|null
     */
    public function getCreated()
    {
        return $this->Created;
    }
    /**
     * Set Created value
     * @param string $created
     * @return \StructType\SaleOrderItemDTO
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created, true), gettype($created)), __LINE__);
        }
        $this->Created = $created;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaleOrderItemDTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
