<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleOrderItemCombinations StructType
 * @subpackage Structs
 */
class SaleOrderItemCombinations extends AbstractStructBase
{
    /**
     * The SaleOrderItemCombination
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\SaleOrderItemCombination[]
     */
    public $SaleOrderItemCombination;
    /**
     * Constructor method for SaleOrderItemCombinations
     * @uses SaleOrderItemCombinations::setSaleOrderItemCombination()
     * @param \StructType\SaleOrderItemCombination[] $saleOrderItemCombination
     */
    public function __construct(array $saleOrderItemCombination = array())
    {
        $this
            ->setSaleOrderItemCombination($saleOrderItemCombination);
    }
    /**
     * Get SaleOrderItemCombination value
     * @return \StructType\SaleOrderItemCombination[]|null
     */
    public function getSaleOrderItemCombination()
    {
        return $this->SaleOrderItemCombination;
    }
    /**
     * This method is responsible for validating the values passed to the setSaleOrderItemCombination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSaleOrderItemCombination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSaleOrderItemCombinationForArrayConstraintsFromSetSaleOrderItemCombination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $saleOrderItemCombinationsSaleOrderItemCombinationItem) {
            // validation for constraint: itemType
            if (!$saleOrderItemCombinationsSaleOrderItemCombinationItem instanceof \StructType\SaleOrderItemCombination) {
                $invalidValues[] = is_object($saleOrderItemCombinationsSaleOrderItemCombinationItem) ? get_class($saleOrderItemCombinationsSaleOrderItemCombinationItem) : sprintf('%s(%s)', gettype($saleOrderItemCombinationsSaleOrderItemCombinationItem), var_export($saleOrderItemCombinationsSaleOrderItemCombinationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SaleOrderItemCombination property can only contain items of type \StructType\SaleOrderItemCombination, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SaleOrderItemCombination value
     * @throws \InvalidArgumentException
     * @param \StructType\SaleOrderItemCombination[] $saleOrderItemCombination
     * @return \StructType\SaleOrderItemCombinations
     */
    public function setSaleOrderItemCombination(array $saleOrderItemCombination = array())
    {
        // validation for constraint: array
        if ('' !== ($saleOrderItemCombinationArrayErrorMessage = self::validateSaleOrderItemCombinationForArrayConstraintsFromSetSaleOrderItemCombination($saleOrderItemCombination))) {
            throw new \InvalidArgumentException($saleOrderItemCombinationArrayErrorMessage, __LINE__);
        }
        $this->SaleOrderItemCombination = $saleOrderItemCombination;
        return $this;
    }
    /**
     * Add item to SaleOrderItemCombination value
     * @throws \InvalidArgumentException
     * @param \StructType\SaleOrderItemCombination $item
     * @return \StructType\SaleOrderItemCombinations
     */
    public function addToSaleOrderItemCombination(\StructType\SaleOrderItemCombination $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SaleOrderItemCombination) {
            throw new \InvalidArgumentException(sprintf('The SaleOrderItemCombination property can only contain items of type \StructType\SaleOrderItemCombination, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SaleOrderItemCombination[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaleOrderItemCombinations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
