<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReversePickupAlternate StructType
 * @subpackage Structs
 */
class ReversePickupAlternate extends AbstractStructBase
{
    /**
     * The ItemSku
     * @var string
     */
    public $ItemSku;
    /**
     * The TotalPrice
     * @var float
     */
    public $TotalPrice;
    /**
     * The SellingPrice
     * @var float
     */
    public $SellingPrice;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Discount;
    /**
     * The ShippingCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ShippingCharges;
    /**
     * The PrepaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PrepaidAmount;
    /**
     * Constructor method for ReversePickupAlternate
     * @uses ReversePickupAlternate::setItemSku()
     * @uses ReversePickupAlternate::setTotalPrice()
     * @uses ReversePickupAlternate::setSellingPrice()
     * @uses ReversePickupAlternate::setDiscount()
     * @uses ReversePickupAlternate::setShippingCharges()
     * @uses ReversePickupAlternate::setPrepaidAmount()
     * @param string $itemSku
     * @param float $totalPrice
     * @param float $sellingPrice
     * @param float $discount
     * @param float $shippingCharges
     * @param float $prepaidAmount
     */
    public function __construct($itemSku = null, $totalPrice = null, $sellingPrice = null, $discount = null, $shippingCharges = null, $prepaidAmount = null)
    {
        $this
            ->setItemSku($itemSku)
            ->setTotalPrice($totalPrice)
            ->setSellingPrice($sellingPrice)
            ->setDiscount($discount)
            ->setShippingCharges($shippingCharges)
            ->setPrepaidAmount($prepaidAmount);
    }
    /**
     * Get ItemSku value
     * @return string|null
     */
    public function getItemSku()
    {
        return $this->ItemSku;
    }
    /**
     * Set ItemSku value
     * @param string $itemSku
     * @return \StructType\ReversePickupAlternate
     */
    public function setItemSku($itemSku = null)
    {
        // validation for constraint: string
        if (!is_null($itemSku) && !is_string($itemSku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSku, true), gettype($itemSku)), __LINE__);
        }
        $this->ItemSku = $itemSku;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return float|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param float $totalPrice
     * @return \StructType\ReversePickupAlternate
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get SellingPrice value
     * @return float|null
     */
    public function getSellingPrice()
    {
        return $this->SellingPrice;
    }
    /**
     * Set SellingPrice value
     * @param float $sellingPrice
     * @return \StructType\ReversePickupAlternate
     */
    public function setSellingPrice($sellingPrice = null)
    {
        // validation for constraint: float
        if (!is_null($sellingPrice) && !(is_float($sellingPrice) || is_numeric($sellingPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sellingPrice, true), gettype($sellingPrice)), __LINE__);
        }
        $this->SellingPrice = $sellingPrice;
        return $this;
    }
    /**
     * Get Discount value
     * @return float|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param float $discount
     * @return \StructType\ReversePickupAlternate
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: float
        if (!is_null($discount) && !(is_float($discount) || is_numeric($discount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount, true), gettype($discount)), __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get ShippingCharges value
     * @return float|null
     */
    public function getShippingCharges()
    {
        return $this->ShippingCharges;
    }
    /**
     * Set ShippingCharges value
     * @param float $shippingCharges
     * @return \StructType\ReversePickupAlternate
     */
    public function setShippingCharges($shippingCharges = null)
    {
        // validation for constraint: float
        if (!is_null($shippingCharges) && !(is_float($shippingCharges) || is_numeric($shippingCharges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingCharges, true), gettype($shippingCharges)), __LINE__);
        }
        $this->ShippingCharges = $shippingCharges;
        return $this;
    }
    /**
     * Get PrepaidAmount value
     * @return float|null
     */
    public function getPrepaidAmount()
    {
        return $this->PrepaidAmount;
    }
    /**
     * Set PrepaidAmount value
     * @param float $prepaidAmount
     * @return \StructType\ReversePickupAlternate
     */
    public function setPrepaidAmount($prepaidAmount = null)
    {
        // validation for constraint: float
        if (!is_null($prepaidAmount) && !(is_float($prepaidAmount) || is_numeric($prepaidAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prepaidAmount, true), gettype($prepaidAmount)), __LINE__);
        }
        $this->PrepaidAmount = $prepaidAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReversePickupAlternate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
