<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetailReversePickupItem StructType
 * @subpackage Structs
 */
class RetailReversePickupItem extends AbstractStructBase
{
    /**
     * The SaleOrderCode
     * @var string
     */
    public $SaleOrderCode;
    /**
     * The ItemCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemCodes
     */
    public $ItemCodes;
    /**
     * Constructor method for RetailReversePickupItem
     * @uses RetailReversePickupItem::setSaleOrderCode()
     * @uses RetailReversePickupItem::setItemCodes()
     * @param string $saleOrderCode
     * @param \StructType\ItemCodes $itemCodes
     */
    public function __construct($saleOrderCode = null, \StructType\ItemCodes $itemCodes = null)
    {
        $this
            ->setSaleOrderCode($saleOrderCode)
            ->setItemCodes($itemCodes);
    }
    /**
     * Get SaleOrderCode value
     * @return string|null
     */
    public function getSaleOrderCode()
    {
        return $this->SaleOrderCode;
    }
    /**
     * Set SaleOrderCode value
     * @param string $saleOrderCode
     * @return \StructType\RetailReversePickupItem
     */
    public function setSaleOrderCode($saleOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderCode) && !is_string($saleOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderCode, true), gettype($saleOrderCode)), __LINE__);
        }
        $this->SaleOrderCode = $saleOrderCode;
        return $this;
    }
    /**
     * Get ItemCodes value
     * @return \StructType\ItemCodes|null
     */
    public function getItemCodes()
    {
        return $this->ItemCodes;
    }
    /**
     * Set ItemCodes value
     * @param \StructType\ItemCodes $itemCodes
     * @return \StructType\RetailReversePickupItem
     */
    public function setItemCodes(\StructType\ItemCodes $itemCodes = null)
    {
        $this->ItemCodes = $itemCodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RetailReversePickupItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
