<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseOrders StructType
 * @subpackage Structs
 */
class PurchaseOrders extends AbstractStructBase
{
    /**
     * The PurchaseOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $PurchaseOrder;
    /**
     * Constructor method for PurchaseOrders
     * @uses PurchaseOrders::setPurchaseOrder()
     * @param string[] $purchaseOrder
     */
    public function __construct(array $purchaseOrder = array())
    {
        $this
            ->setPurchaseOrder($purchaseOrder);
    }
    /**
     * Get PurchaseOrder value
     * @return string[]|null
     */
    public function getPurchaseOrder()
    {
        return $this->PurchaseOrder;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchaseOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchaseOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchaseOrderForArrayConstraintsFromSetPurchaseOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchaseOrdersPurchaseOrderItem) {
            // validation for constraint: itemType
            if (!is_string($purchaseOrdersPurchaseOrderItem)) {
                $invalidValues[] = is_object($purchaseOrdersPurchaseOrderItem) ? get_class($purchaseOrdersPurchaseOrderItem) : sprintf('%s(%s)', gettype($purchaseOrdersPurchaseOrderItem), var_export($purchaseOrdersPurchaseOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PurchaseOrder property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PurchaseOrder value
     * @throws \InvalidArgumentException
     * @param string[] $purchaseOrder
     * @return \StructType\PurchaseOrders
     */
    public function setPurchaseOrder(array $purchaseOrder = array())
    {
        // validation for constraint: array
        if ('' !== ($purchaseOrderArrayErrorMessage = self::validatePurchaseOrderForArrayConstraintsFromSetPurchaseOrder($purchaseOrder))) {
            throw new \InvalidArgumentException($purchaseOrderArrayErrorMessage, __LINE__);
        }
        $this->PurchaseOrder = $purchaseOrder;
        return $this;
    }
    /**
     * Add item to PurchaseOrder value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PurchaseOrders
     */
    public function addToPurchaseOrder($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PurchaseOrder property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PurchaseOrder[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PurchaseOrders
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
