<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseOrder StructType
 * @subpackage Structs
 */
class PurchaseOrder extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The FromParty
     * @var string
     */
    public $FromParty;
    /**
     * The VendorCode
     * @var string
     */
    public $VendorCode;
    /**
     * The VendorName
     * @var string
     */
    public $VendorName;
    /**
     * The StatusCode
     * @var string
     */
    public $StatusCode;
    /**
     * The Created
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Created;
    /**
     * The Approved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Approved;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDate;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpiryDate;
    /**
     * The CustomFields
     * @var \StructType\CustomFields
     */
    public $CustomFields;
    /**
     * Constructor method for PurchaseOrder
     * @uses PurchaseOrder::setCode()
     * @uses PurchaseOrder::setFromParty()
     * @uses PurchaseOrder::setVendorCode()
     * @uses PurchaseOrder::setVendorName()
     * @uses PurchaseOrder::setStatusCode()
     * @uses PurchaseOrder::setCreated()
     * @uses PurchaseOrder::setApproved()
     * @uses PurchaseOrder::setDeliveryDate()
     * @uses PurchaseOrder::setExpiryDate()
     * @uses PurchaseOrder::setCustomFields()
     * @param string $code
     * @param string $fromParty
     * @param string $vendorCode
     * @param string $vendorName
     * @param string $statusCode
     * @param string $created
     * @param string $approved
     * @param string $deliveryDate
     * @param string $expiryDate
     * @param \StructType\CustomFields $customFields
     */
    public function __construct($code = null, $fromParty = null, $vendorCode = null, $vendorName = null, $statusCode = null, $created = null, $approved = null, $deliveryDate = null, $expiryDate = null, \StructType\CustomFields $customFields = null)
    {
        $this
            ->setCode($code)
            ->setFromParty($fromParty)
            ->setVendorCode($vendorCode)
            ->setVendorName($vendorName)
            ->setStatusCode($statusCode)
            ->setCreated($created)
            ->setApproved($approved)
            ->setDeliveryDate($deliveryDate)
            ->setExpiryDate($expiryDate)
            ->setCustomFields($customFields);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\PurchaseOrder
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get FromParty value
     * @return string|null
     */
    public function getFromParty()
    {
        return $this->FromParty;
    }
    /**
     * Set FromParty value
     * @param string $fromParty
     * @return \StructType\PurchaseOrder
     */
    public function setFromParty($fromParty = null)
    {
        // validation for constraint: string
        if (!is_null($fromParty) && !is_string($fromParty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromParty, true), gettype($fromParty)), __LINE__);
        }
        $this->FromParty = $fromParty;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\PurchaseOrder
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode, true), gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get VendorName value
     * @return string|null
     */
    public function getVendorName()
    {
        return $this->VendorName;
    }
    /**
     * Set VendorName value
     * @param string $vendorName
     * @return \StructType\PurchaseOrder
     */
    public function setVendorName($vendorName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorName) && !is_string($vendorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorName, true), gettype($vendorName)), __LINE__);
        }
        $this->VendorName = $vendorName;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\PurchaseOrder
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get Created value
     * @return string|null
     */
    public function getCreated()
    {
        return $this->Created;
    }
    /**
     * Set Created value
     * @param string $created
     * @return \StructType\PurchaseOrder
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created, true), gettype($created)), __LINE__);
        }
        $this->Created = $created;
        return $this;
    }
    /**
     * Get Approved value
     * @return string|null
     */
    public function getApproved()
    {
        return $this->Approved;
    }
    /**
     * Set Approved value
     * @param string $approved
     * @return \StructType\PurchaseOrder
     */
    public function setApproved($approved = null)
    {
        // validation for constraint: string
        if (!is_null($approved) && !is_string($approved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approved, true), gettype($approved)), __LINE__);
        }
        $this->Approved = $approved;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \StructType\PurchaseOrder
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param string $expiryDate
     * @return \StructType\PurchaseOrder
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \StructType\CustomFields|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \StructType\CustomFields $customFields
     * @return \StructType\PurchaseOrder
     */
    public function setCustomFields(\StructType\CustomFields $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PurchaseOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
