<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartyAddressDTO StructType
 * @subpackage Structs
 */
class PartyAddressDTO extends AbstractStructBase
{
    /**
     * The AddressType
     * @var string
     */
    public $AddressType;
    /**
     * The AddressTypeName
     * @var string
     */
    public $AddressTypeName;
    /**
     * The StateCode
     * @var string
     */
    public $StateCode;
    /**
     * The StateName
     * @var string
     */
    public $StateName;
    /**
     * The CountryCode
     * @var string
     */
    public $CountryCode;
    /**
     * The AddressLine1
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine2;
    /**
     * The Pincode
     * @var string
     */
    public $Pincode;
    /**
     * The Phone
     * @var string
     */
    public $Phone;
    /**
     * The Enabled
     * @var string
     */
    public $Enabled;
    /**
     * Constructor method for PartyAddressDTO
     * @uses PartyAddressDTO::setAddressType()
     * @uses PartyAddressDTO::setAddressTypeName()
     * @uses PartyAddressDTO::setStateCode()
     * @uses PartyAddressDTO::setStateName()
     * @uses PartyAddressDTO::setCountryCode()
     * @uses PartyAddressDTO::setAddressLine1()
     * @uses PartyAddressDTO::setAddressLine2()
     * @uses PartyAddressDTO::setPincode()
     * @uses PartyAddressDTO::setPhone()
     * @uses PartyAddressDTO::setEnabled()
     * @param string $addressType
     * @param string $addressTypeName
     * @param string $stateCode
     * @param string $stateName
     * @param string $countryCode
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $pincode
     * @param string $phone
     * @param string $enabled
     */
    public function __construct($addressType = null, $addressTypeName = null, $stateCode = null, $stateName = null, $countryCode = null, $addressLine1 = null, $addressLine2 = null, $pincode = null, $phone = null, $enabled = null)
    {
        $this
            ->setAddressType($addressType)
            ->setAddressTypeName($addressTypeName)
            ->setStateCode($stateCode)
            ->setStateName($stateName)
            ->setCountryCode($countryCode)
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setPincode($pincode)
            ->setPhone($phone)
            ->setEnabled($enabled);
    }
    /**
     * Get AddressType value
     * @return string|null
     */
    public function getAddressType()
    {
        return $this->AddressType;
    }
    /**
     * Set AddressType value
     * @param string $addressType
     * @return \StructType\PartyAddressDTO
     */
    public function setAddressType($addressType = null)
    {
        // validation for constraint: string
        if (!is_null($addressType) && !is_string($addressType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressType, true), gettype($addressType)), __LINE__);
        }
        $this->AddressType = $addressType;
        return $this;
    }
    /**
     * Get AddressTypeName value
     * @return string|null
     */
    public function getAddressTypeName()
    {
        return $this->AddressTypeName;
    }
    /**
     * Set AddressTypeName value
     * @param string $addressTypeName
     * @return \StructType\PartyAddressDTO
     */
    public function setAddressTypeName($addressTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($addressTypeName) && !is_string($addressTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressTypeName, true), gettype($addressTypeName)), __LINE__);
        }
        $this->AddressTypeName = $addressTypeName;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \StructType\PartyAddressDTO
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateCode, true), gettype($stateCode)), __LINE__);
        }
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get StateName value
     * @return string|null
     */
    public function getStateName()
    {
        return $this->StateName;
    }
    /**
     * Set StateName value
     * @param string $stateName
     * @return \StructType\PartyAddressDTO
     */
    public function setStateName($stateName = null)
    {
        // validation for constraint: string
        if (!is_null($stateName) && !is_string($stateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateName, true), gettype($stateName)), __LINE__);
        }
        $this->StateName = $stateName;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\PartyAddressDTO
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get AddressLine1 value
     * @return string|null
     */
    public function getAddressLine1()
    {
        return $this->AddressLine1;
    }
    /**
     * Set AddressLine1 value
     * @param string $addressLine1
     * @return \StructType\PartyAddressDTO
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine1, true), gettype($addressLine1)), __LINE__);
        }
        $this->AddressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get AddressLine2 value
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->AddressLine2;
    }
    /**
     * Set AddressLine2 value
     * @param string $addressLine2
     * @return \StructType\PartyAddressDTO
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine2, true), gettype($addressLine2)), __LINE__);
        }
        $this->AddressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get Pincode value
     * @return string|null
     */
    public function getPincode()
    {
        return $this->Pincode;
    }
    /**
     * Set Pincode value
     * @param string $pincode
     * @return \StructType\PartyAddressDTO
     */
    public function setPincode($pincode = null)
    {
        // validation for constraint: string
        if (!is_null($pincode) && !is_string($pincode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pincode, true), gettype($pincode)), __LINE__);
        }
        $this->Pincode = $pincode;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\PartyAddressDTO
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Enabled value
     * @return string|null
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param string $enabled
     * @return \StructType\PartyAddressDTO
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: string
        if (!is_null($enabled) && !is_string($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PartyAddressDTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
