<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemType StructType
 * @subpackage Structs
 */
class ItemType extends AbstractStructBase
{
    /**
     * The ItemSKU
     * @var string
     */
    public $ItemSKU;
    /**
     * The SKUCode
     * @var string
     */
    public $SKUCode;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The Length
     * @var int
     */
    public $Length;
    /**
     * The Width
     * @var int
     */
    public $Width;
    /**
     * The Height
     * @var int
     */
    public $Height;
    /**
     * The Weight
     * @var int
     */
    public $Weight;
    /**
     * The Color
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Color;
    /**
     * The Brand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Brand;
    /**
     * The Size
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Size;
    /**
     * The Price
     * @var float
     */
    public $Price;
    /**
     * The TaxTypeCode
     * @var string
     */
    public $TaxTypeCode;
    /**
     * The CategoryName
     * @var string
     */
    public $CategoryName;
    /**
     * The CategoryCode
     * @var string
     */
    public $CategoryCode;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFields
     */
    public $CustomFields;
    /**
     * The InventorySnapshots
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InventorySnapshots
     */
    public $InventorySnapshots;
    /**
     * The SkuCode
     * @var string
     */
    public $SkuCode;
    /**
     * The ImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImageUrl;
    /**
     * The PageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PageUrl;
    /**
     * The Inventory
     * @var int
     */
    public $Inventory;
    /**
     * The OpenSale
     * @var int
     */
    public $OpenSale;
    /**
     * The OpenPurchase
     * @var int
     */
    public $OpenPurchase;
    /**
     * The PutawayPending
     * @var int
     */
    public $PutawayPending;
    /**
     * The InPicking
     * @var int
     */
    public $InPicking;
    /**
     * The PendingGRN
     * @var int
     */
    public $PendingGRN;
    /**
     * The Enabled
     * @var bool
     */
    public $Enabled;
    /**
     * Constructor method for ItemType
     * @uses ItemType::setItemSKU()
     * @uses ItemType::setSKUCode()
     * @uses ItemType::setName()
     * @uses ItemType::setDescription()
     * @uses ItemType::setLength()
     * @uses ItemType::setWidth()
     * @uses ItemType::setHeight()
     * @uses ItemType::setWeight()
     * @uses ItemType::setColor()
     * @uses ItemType::setBrand()
     * @uses ItemType::setSize()
     * @uses ItemType::setPrice()
     * @uses ItemType::setTaxTypeCode()
     * @uses ItemType::setCategoryName()
     * @uses ItemType::setCategoryCode()
     * @uses ItemType::setCustomFields()
     * @uses ItemType::setInventorySnapshots()
     * @uses ItemType::setSkuCode_1()
     * @uses ItemType::setImageUrl()
     * @uses ItemType::setPageUrl()
     * @uses ItemType::setInventory()
     * @uses ItemType::setOpenSale()
     * @uses ItemType::setOpenPurchase()
     * @uses ItemType::setPutawayPending()
     * @uses ItemType::setInPicking()
     * @uses ItemType::setPendingGRN()
     * @uses ItemType::setEnabled()
     * @param string $itemSKU
     * @param string $sKUCode
     * @param string $name
     * @param string $description
     * @param int $length
     * @param int $width
     * @param int $height
     * @param int $weight
     * @param string $color
     * @param string $brand
     * @param string $size
     * @param float $price
     * @param string $taxTypeCode
     * @param string $categoryName
     * @param string $categoryCode
     * @param \StructType\CustomFields $customFields
     * @param \StructType\InventorySnapshots $inventorySnapshots
     * @param string $skuCode
     * @param string $imageUrl
     * @param string $pageUrl
     * @param int $inventory
     * @param int $openSale
     * @param int $openPurchase
     * @param int $putawayPending
     * @param int $inPicking
     * @param int $pendingGRN
     * @param bool $enabled
     */
    public function __construct($itemSKU = null, $sKUCode = null, $name = null, $description = null, $length = null, $width = null, $height = null, $weight = null, $color = null, $brand = null, $size = null, $price = null, $taxTypeCode = null, $categoryName = null, $categoryCode = null, \StructType\CustomFields $customFields = null, \StructType\InventorySnapshots $inventorySnapshots = null, $skuCode_1 = null, $imageUrl = null, $pageUrl = null, $inventory = null, $openSale = null, $openPurchase = null, $putawayPending = null, $inPicking = null, $pendingGRN = null, $enabled = null)
    {
        $this
            ->setItemSKU($itemSKU)
            ->setSKUCode($sKUCode)
            ->setName($name)
            ->setDescription($description)
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height)
            ->setWeight($weight)
            ->setColor($color)
            ->setBrand($brand)
            ->setSize($size)
            ->setPrice($price)
            ->setTaxTypeCode($taxTypeCode)
            ->setCategoryName($categoryName)
            ->setCategoryCode($categoryCode)
            ->setCustomFields($customFields)
            ->setInventorySnapshots($inventorySnapshots)
            ->setSkuCode_1($skuCode_1)
            ->setImageUrl($imageUrl)
            ->setPageUrl($pageUrl)
            ->setInventory($inventory)
            ->setOpenSale($openSale)
            ->setOpenPurchase($openPurchase)
            ->setPutawayPending($putawayPending)
            ->setInPicking($inPicking)
            ->setPendingGRN($pendingGRN)
            ->setEnabled($enabled);
    }
    /**
     * Get ItemSKU value
     * @return string|null
     */
    public function getItemSKU()
    {
        return $this->ItemSKU;
    }
    /**
     * Set ItemSKU value
     * @param string $itemSKU
     * @return \StructType\ItemType
     */
    public function setItemSKU($itemSKU = null)
    {
        // validation for constraint: string
        if (!is_null($itemSKU) && !is_string($itemSKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSKU, true), gettype($itemSKU)), __LINE__);
        }
        $this->ItemSKU = $itemSKU;
        return $this;
    }
    /**
     * Get SKUCode value
     * @return string|null
     */
    public function getSKUCode()
    {
        return $this->SKUCode;
    }
    /**
     * Set SKUCode value
     * @param string $sKUCode
     * @return \StructType\ItemType
     */
    public function setSKUCode($sKUCode = null)
    {
        // validation for constraint: string
        if (!is_null($sKUCode) && !is_string($sKUCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sKUCode, true), gettype($sKUCode)), __LINE__);
        }
        $this->SKUCode = $sKUCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ItemType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ItemType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Length value
     * @return int|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param int $length
     * @return \StructType\ItemType
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !(is_int($length) || ctype_digit($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param int $width
     * @return \StructType\ItemType
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !(is_int($width) || ctype_digit($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param int $height
     * @return \StructType\ItemType
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !(is_int($height) || ctype_digit($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param int $weight
     * @return \StructType\ItemType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !(is_int($weight) || ctype_digit($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @param string $color
     * @return \StructType\ItemType
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        $this->Color = $color;
        return $this;
    }
    /**
     * Get Brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param string $brand
     * @return \StructType\ItemType
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Get Size value
     * @return string|null
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param string $size
     * @return \StructType\ItemType
     */
    public function setSize($size = null)
    {
        // validation for constraint: string
        if (!is_null($size) && !is_string($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->Size = $size;
        return $this;
    }
    /**
     * Get Price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\ItemType
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get TaxTypeCode value
     * @return string|null
     */
    public function getTaxTypeCode()
    {
        return $this->TaxTypeCode;
    }
    /**
     * Set TaxTypeCode value
     * @param string $taxTypeCode
     * @return \StructType\ItemType
     */
    public function setTaxTypeCode($taxTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxTypeCode) && !is_string($taxTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxTypeCode, true), gettype($taxTypeCode)), __LINE__);
        }
        $this->TaxTypeCode = $taxTypeCode;
        return $this;
    }
    /**
     * Get CategoryName value
     * @return string|null
     */
    public function getCategoryName()
    {
        return $this->CategoryName;
    }
    /**
     * Set CategoryName value
     * @param string $categoryName
     * @return \StructType\ItemType
     */
    public function setCategoryName($categoryName = null)
    {
        // validation for constraint: string
        if (!is_null($categoryName) && !is_string($categoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryName, true), gettype($categoryName)), __LINE__);
        }
        $this->CategoryName = $categoryName;
        return $this;
    }
    /**
     * Get CategoryCode value
     * @return string|null
     */
    public function getCategoryCode()
    {
        return $this->CategoryCode;
    }
    /**
     * Set CategoryCode value
     * @param string $categoryCode
     * @return \StructType\ItemType
     */
    public function setCategoryCode($categoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($categoryCode) && !is_string($categoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryCode, true), gettype($categoryCode)), __LINE__);
        }
        $this->CategoryCode = $categoryCode;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \StructType\CustomFields|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \StructType\CustomFields $customFields
     * @return \StructType\ItemType
     */
    public function setCustomFields(\StructType\CustomFields $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Get InventorySnapshots value
     * @return \StructType\InventorySnapshots|null
     */
    public function getInventorySnapshots()
    {
        return $this->InventorySnapshots;
    }
    /**
     * Set InventorySnapshots value
     * @param \StructType\InventorySnapshots $inventorySnapshots
     * @return \StructType\ItemType
     */
    public function setInventorySnapshots(\StructType\InventorySnapshots $inventorySnapshots = null)
    {
        $this->InventorySnapshots = $inventorySnapshots;
        return $this;
    }
    /**
     * Get SkuCode value
     * @return string|null
     */
    public function getSkuCode_1()
    {
        return $this->SkuCode;
    }
    /**
     * Set SkuCode value
     * @param string $skuCode
     * @return \StructType\ItemType
     */
    public function setSkuCode_1($skuCode_1 = null)
    {
        // validation for constraint: string
        if (!is_null($skuCode_1) && !is_string($skuCode_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($skuCode_1, true), gettype($skuCode_1)), __LINE__);
        }
        $this->SkuCode = $skuCode_1;
        return $this;
    }
    /**
     * Get ImageUrl value
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->ImageUrl;
    }
    /**
     * Set ImageUrl value
     * @param string $imageUrl
     * @return \StructType\ItemType
     */
    public function setImageUrl($imageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($imageUrl) && !is_string($imageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageUrl, true), gettype($imageUrl)), __LINE__);
        }
        $this->ImageUrl = $imageUrl;
        return $this;
    }
    /**
     * Get PageUrl value
     * @return string|null
     */
    public function getPageUrl()
    {
        return $this->PageUrl;
    }
    /**
     * Set PageUrl value
     * @param string $pageUrl
     * @return \StructType\ItemType
     */
    public function setPageUrl($pageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($pageUrl) && !is_string($pageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageUrl, true), gettype($pageUrl)), __LINE__);
        }
        $this->PageUrl = $pageUrl;
        return $this;
    }
    /**
     * Get Inventory value
     * @return int|null
     */
    public function getInventory()
    {
        return $this->Inventory;
    }
    /**
     * Set Inventory value
     * @param int $inventory
     * @return \StructType\ItemType
     */
    public function setInventory($inventory = null)
    {
        // validation for constraint: int
        if (!is_null($inventory) && !(is_int($inventory) || ctype_digit($inventory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inventory, true), gettype($inventory)), __LINE__);
        }
        $this->Inventory = $inventory;
        return $this;
    }
    /**
     * Get OpenSale value
     * @return int|null
     */
    public function getOpenSale()
    {
        return $this->OpenSale;
    }
    /**
     * Set OpenSale value
     * @param int $openSale
     * @return \StructType\ItemType
     */
    public function setOpenSale($openSale = null)
    {
        // validation for constraint: int
        if (!is_null($openSale) && !(is_int($openSale) || ctype_digit($openSale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($openSale, true), gettype($openSale)), __LINE__);
        }
        $this->OpenSale = $openSale;
        return $this;
    }
    /**
     * Get OpenPurchase value
     * @return int|null
     */
    public function getOpenPurchase()
    {
        return $this->OpenPurchase;
    }
    /**
     * Set OpenPurchase value
     * @param int $openPurchase
     * @return \StructType\ItemType
     */
    public function setOpenPurchase($openPurchase = null)
    {
        // validation for constraint: int
        if (!is_null($openPurchase) && !(is_int($openPurchase) || ctype_digit($openPurchase))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($openPurchase, true), gettype($openPurchase)), __LINE__);
        }
        $this->OpenPurchase = $openPurchase;
        return $this;
    }
    /**
     * Get PutawayPending value
     * @return int|null
     */
    public function getPutawayPending()
    {
        return $this->PutawayPending;
    }
    /**
     * Set PutawayPending value
     * @param int $putawayPending
     * @return \StructType\ItemType
     */
    public function setPutawayPending($putawayPending = null)
    {
        // validation for constraint: int
        if (!is_null($putawayPending) && !(is_int($putawayPending) || ctype_digit($putawayPending))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($putawayPending, true), gettype($putawayPending)), __LINE__);
        }
        $this->PutawayPending = $putawayPending;
        return $this;
    }
    /**
     * Get InPicking value
     * @return int|null
     */
    public function getInPicking()
    {
        return $this->InPicking;
    }
    /**
     * Set InPicking value
     * @param int $inPicking
     * @return \StructType\ItemType
     */
    public function setInPicking($inPicking = null)
    {
        // validation for constraint: int
        if (!is_null($inPicking) && !(is_int($inPicking) || ctype_digit($inPicking))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inPicking, true), gettype($inPicking)), __LINE__);
        }
        $this->InPicking = $inPicking;
        return $this;
    }
    /**
     * Get PendingGRN value
     * @return int|null
     */
    public function getPendingGRN()
    {
        return $this->PendingGRN;
    }
    /**
     * Set PendingGRN value
     * @param int $pendingGRN
     * @return \StructType\ItemType
     */
    public function setPendingGRN($pendingGRN = null)
    {
        // validation for constraint: int
        if (!is_null($pendingGRN) && !(is_int($pendingGRN) || ctype_digit($pendingGRN))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pendingGRN, true), gettype($pendingGRN)), __LINE__);
        }
        $this->PendingGRN = $pendingGRN;
        return $this;
    }
    /**
     * Get Enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \StructType\ItemType
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
