<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemDetailFields StructType
 * @subpackage Structs
 */
class ItemDetailFields extends AbstractStructBase
{
    /**
     * The ItemDetailField
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $ItemDetailField;
    /**
     * Constructor method for ItemDetailFields
     * @uses ItemDetailFields::setItemDetailField()
     * @param string[] $itemDetailField
     */
    public function __construct(array $itemDetailField = array())
    {
        $this
            ->setItemDetailField($itemDetailField);
    }
    /**
     * Get ItemDetailField value
     * @return string[]|null
     */
    public function getItemDetailField()
    {
        return $this->ItemDetailField;
    }
    /**
     * This method is responsible for validating the values passed to the setItemDetailField method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemDetailField method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemDetailFieldForArrayConstraintsFromSetItemDetailField(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemDetailFieldsItemDetailFieldItem) {
            // validation for constraint: itemType
            if (!is_string($itemDetailFieldsItemDetailFieldItem)) {
                $invalidValues[] = is_object($itemDetailFieldsItemDetailFieldItem) ? get_class($itemDetailFieldsItemDetailFieldItem) : sprintf('%s(%s)', gettype($itemDetailFieldsItemDetailFieldItem), var_export($itemDetailFieldsItemDetailFieldItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemDetailField property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemDetailField value
     * @throws \InvalidArgumentException
     * @param string[] $itemDetailField
     * @return \StructType\ItemDetailFields
     */
    public function setItemDetailField(array $itemDetailField = array())
    {
        // validation for constraint: array
        if ('' !== ($itemDetailFieldArrayErrorMessage = self::validateItemDetailFieldForArrayConstraintsFromSetItemDetailField($itemDetailField))) {
            throw new \InvalidArgumentException($itemDetailFieldArrayErrorMessage, __LINE__);
        }
        $this->ItemDetailField = $itemDetailField;
        return $this;
    }
    /**
     * Add item to ItemDetailField value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ItemDetailFields
     */
    public function addToItemDetailField($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ItemDetailField property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemDetailField[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemDetailFields
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
