<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTaxTypeConfigurationRequest StructType
 * @subpackage Structs
 */
class GetTaxTypeConfigurationRequest extends AbstractStructBase
{
    /**
     * The TaxTypeCode
     * @var string
     */
    public $TaxTypeCode;
    /**
     * Constructor method for GetTaxTypeConfigurationRequest
     * @uses GetTaxTypeConfigurationRequest::setTaxTypeCode()
     * @param string $taxTypeCode
     */
    public function __construct($taxTypeCode = null)
    {
        $this
            ->setTaxTypeCode($taxTypeCode);
    }
    /**
     * Get TaxTypeCode value
     * @return string|null
     */
    public function getTaxTypeCode()
    {
        return $this->TaxTypeCode;
    }
    /**
     * Set TaxTypeCode value
     * @param string $taxTypeCode
     * @return \StructType\GetTaxTypeConfigurationRequest
     */
    public function setTaxTypeCode($taxTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxTypeCode) && !is_string($taxTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxTypeCode, true), gettype($taxTypeCode)), __LINE__);
        }
        $this->TaxTypeCode = $taxTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetTaxTypeConfigurationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
