<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetServiceabilityRequest StructType
 * @subpackage Structs
 */
class GetServiceabilityRequest extends AbstractStructBase
{
    /**
     * The Pincode
     * @var string
     */
    public $Pincode;
    /**
     * The CashOnDelivery
     * @var bool
     */
    public $CashOnDelivery;
    /**
     * Constructor method for GetServiceabilityRequest
     * @uses GetServiceabilityRequest::setPincode()
     * @uses GetServiceabilityRequest::setCashOnDelivery()
     * @param string $pincode
     * @param bool $cashOnDelivery
     */
    public function __construct($pincode = null, $cashOnDelivery = null)
    {
        $this
            ->setPincode($pincode)
            ->setCashOnDelivery($cashOnDelivery);
    }
    /**
     * Get Pincode value
     * @return string|null
     */
    public function getPincode()
    {
        return $this->Pincode;
    }
    /**
     * Set Pincode value
     * @param string $pincode
     * @return \StructType\GetServiceabilityRequest
     */
    public function setPincode($pincode = null)
    {
        // validation for constraint: string
        if (!is_null($pincode) && !is_string($pincode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pincode, true), gettype($pincode)), __LINE__);
        }
        $this->Pincode = $pincode;
        return $this;
    }
    /**
     * Get CashOnDelivery value
     * @return bool|null
     */
    public function getCashOnDelivery()
    {
        return $this->CashOnDelivery;
    }
    /**
     * Set CashOnDelivery value
     * @param bool $cashOnDelivery
     * @return \StructType\GetServiceabilityRequest
     */
    public function setCashOnDelivery($cashOnDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($cashOnDelivery) && !is_bool($cashOnDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cashOnDelivery, true), gettype($cashOnDelivery)), __LINE__);
        }
        $this->CashOnDelivery = $cashOnDelivery;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetServiceabilityRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
