<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPurchaseOrderDetailResponse StructType
 * @subpackage Structs
 */
class GetPurchaseOrderDetailResponse extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The AmendedPurchaseOrderCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AmendedPurchaseOrderCode;
    /**
     * The AmendmentPurchaseOrderCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AmendmentPurchaseOrderCode;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The FromParty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FromParty;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The VendorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorCode;
    /**
     * The VendorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorName;
    /**
     * The Created
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Created;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpiryDate;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDate;
    /**
     * The VendorAgreementName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VendorAgreementName;
    /**
     * The InflowReceiptsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InflowReceiptsCount;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFields
     */
    public $CustomFields;
    /**
     * The PurchaseOrderItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PurchaseOrderItems
     */
    public $PurchaseOrderItems;
    /**
     * The PartyAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PartyAddress[]
     */
    public $PartyAddress;
    /**
     * Constructor method for GetPurchaseOrderDetailResponse
     * @uses GetPurchaseOrderDetailResponse::setId()
     * @uses GetPurchaseOrderDetailResponse::setAmendedPurchaseOrderCode()
     * @uses GetPurchaseOrderDetailResponse::setAmendmentPurchaseOrderCode()
     * @uses GetPurchaseOrderDetailResponse::setCode()
     * @uses GetPurchaseOrderDetailResponse::setType()
     * @uses GetPurchaseOrderDetailResponse::setFromParty()
     * @uses GetPurchaseOrderDetailResponse::setStatusCode()
     * @uses GetPurchaseOrderDetailResponse::setVendorCode()
     * @uses GetPurchaseOrderDetailResponse::setVendorName()
     * @uses GetPurchaseOrderDetailResponse::setCreated()
     * @uses GetPurchaseOrderDetailResponse::setExpiryDate()
     * @uses GetPurchaseOrderDetailResponse::setDeliveryDate()
     * @uses GetPurchaseOrderDetailResponse::setVendorAgreementName()
     * @uses GetPurchaseOrderDetailResponse::setInflowReceiptsCount()
     * @uses GetPurchaseOrderDetailResponse::setCustomFields()
     * @uses GetPurchaseOrderDetailResponse::setPurchaseOrderItems()
     * @uses GetPurchaseOrderDetailResponse::setPartyAddress()
     * @param string $id
     * @param string $amendedPurchaseOrderCode
     * @param string $amendmentPurchaseOrderCode
     * @param string $code
     * @param string $type
     * @param string $fromParty
     * @param string $statusCode
     * @param string $vendorCode
     * @param string $vendorName
     * @param string $created
     * @param string $expiryDate
     * @param string $deliveryDate
     * @param string $vendorAgreementName
     * @param string $inflowReceiptsCount
     * @param \StructType\CustomFields $customFields
     * @param \StructType\PurchaseOrderItems $purchaseOrderItems
     * @param \StructType\PartyAddress[] $partyAddress
     */
    public function __construct($id = null, $amendedPurchaseOrderCode = null, $amendmentPurchaseOrderCode = null, $code = null, $type = null, $fromParty = null, $statusCode = null, $vendorCode = null, $vendorName = null, $created = null, $expiryDate = null, $deliveryDate = null, $vendorAgreementName = null, $inflowReceiptsCount = null, \StructType\CustomFields $customFields = null, \StructType\PurchaseOrderItems $purchaseOrderItems = null, array $partyAddress = array())
    {
        $this
            ->setId($id)
            ->setAmendedPurchaseOrderCode($amendedPurchaseOrderCode)
            ->setAmendmentPurchaseOrderCode($amendmentPurchaseOrderCode)
            ->setCode($code)
            ->setType($type)
            ->setFromParty($fromParty)
            ->setStatusCode($statusCode)
            ->setVendorCode($vendorCode)
            ->setVendorName($vendorName)
            ->setCreated($created)
            ->setExpiryDate($expiryDate)
            ->setDeliveryDate($deliveryDate)
            ->setVendorAgreementName($vendorAgreementName)
            ->setInflowReceiptsCount($inflowReceiptsCount)
            ->setCustomFields($customFields)
            ->setPurchaseOrderItems($purchaseOrderItems)
            ->setPartyAddress($partyAddress);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get AmendedPurchaseOrderCode value
     * @return string|null
     */
    public function getAmendedPurchaseOrderCode()
    {
        return $this->AmendedPurchaseOrderCode;
    }
    /**
     * Set AmendedPurchaseOrderCode value
     * @param string $amendedPurchaseOrderCode
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setAmendedPurchaseOrderCode($amendedPurchaseOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($amendedPurchaseOrderCode) && !is_string($amendedPurchaseOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amendedPurchaseOrderCode, true), gettype($amendedPurchaseOrderCode)), __LINE__);
        }
        $this->AmendedPurchaseOrderCode = $amendedPurchaseOrderCode;
        return $this;
    }
    /**
     * Get AmendmentPurchaseOrderCode value
     * @return string|null
     */
    public function getAmendmentPurchaseOrderCode()
    {
        return $this->AmendmentPurchaseOrderCode;
    }
    /**
     * Set AmendmentPurchaseOrderCode value
     * @param string $amendmentPurchaseOrderCode
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setAmendmentPurchaseOrderCode($amendmentPurchaseOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($amendmentPurchaseOrderCode) && !is_string($amendmentPurchaseOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amendmentPurchaseOrderCode, true), gettype($amendmentPurchaseOrderCode)), __LINE__);
        }
        $this->AmendmentPurchaseOrderCode = $amendmentPurchaseOrderCode;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get FromParty value
     * @return string|null
     */
    public function getFromParty()
    {
        return $this->FromParty;
    }
    /**
     * Set FromParty value
     * @param string $fromParty
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setFromParty($fromParty = null)
    {
        // validation for constraint: string
        if (!is_null($fromParty) && !is_string($fromParty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromParty, true), gettype($fromParty)), __LINE__);
        }
        $this->FromParty = $fromParty;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode, true), gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get VendorName value
     * @return string|null
     */
    public function getVendorName()
    {
        return $this->VendorName;
    }
    /**
     * Set VendorName value
     * @param string $vendorName
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setVendorName($vendorName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorName) && !is_string($vendorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorName, true), gettype($vendorName)), __LINE__);
        }
        $this->VendorName = $vendorName;
        return $this;
    }
    /**
     * Get Created value
     * @return string|null
     */
    public function getCreated()
    {
        return $this->Created;
    }
    /**
     * Set Created value
     * @param string $created
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($created, true), gettype($created)), __LINE__);
        }
        $this->Created = $created;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param string $expiryDate
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get VendorAgreementName value
     * @return string|null
     */
    public function getVendorAgreementName()
    {
        return $this->VendorAgreementName;
    }
    /**
     * Set VendorAgreementName value
     * @param string $vendorAgreementName
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setVendorAgreementName($vendorAgreementName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorAgreementName) && !is_string($vendorAgreementName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorAgreementName, true), gettype($vendorAgreementName)), __LINE__);
        }
        $this->VendorAgreementName = $vendorAgreementName;
        return $this;
    }
    /**
     * Get InflowReceiptsCount value
     * @return string|null
     */
    public function getInflowReceiptsCount()
    {
        return $this->InflowReceiptsCount;
    }
    /**
     * Set InflowReceiptsCount value
     * @param string $inflowReceiptsCount
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setInflowReceiptsCount($inflowReceiptsCount = null)
    {
        // validation for constraint: string
        if (!is_null($inflowReceiptsCount) && !is_string($inflowReceiptsCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inflowReceiptsCount, true), gettype($inflowReceiptsCount)), __LINE__);
        }
        $this->InflowReceiptsCount = $inflowReceiptsCount;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \StructType\CustomFields|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \StructType\CustomFields $customFields
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setCustomFields(\StructType\CustomFields $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Get PurchaseOrderItems value
     * @return \StructType\PurchaseOrderItems|null
     */
    public function getPurchaseOrderItems()
    {
        return $this->PurchaseOrderItems;
    }
    /**
     * Set PurchaseOrderItems value
     * @param \StructType\PurchaseOrderItems $purchaseOrderItems
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setPurchaseOrderItems(\StructType\PurchaseOrderItems $purchaseOrderItems = null)
    {
        $this->PurchaseOrderItems = $purchaseOrderItems;
        return $this;
    }
    /**
     * Get PartyAddress value
     * @return \StructType\PartyAddress[]|null
     */
    public function getPartyAddress()
    {
        return $this->PartyAddress;
    }
    /**
     * This method is responsible for validating the values passed to the setPartyAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartyAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartyAddressForArrayConstraintsFromSetPartyAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getPurchaseOrderDetailResponsePartyAddressItem) {
            // validation for constraint: itemType
            if (!$getPurchaseOrderDetailResponsePartyAddressItem instanceof \StructType\PartyAddress) {
                $invalidValues[] = is_object($getPurchaseOrderDetailResponsePartyAddressItem) ? get_class($getPurchaseOrderDetailResponsePartyAddressItem) : sprintf('%s(%s)', gettype($getPurchaseOrderDetailResponsePartyAddressItem), var_export($getPurchaseOrderDetailResponsePartyAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PartyAddress property can only contain items of type \StructType\PartyAddress, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PartyAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\PartyAddress[] $partyAddress
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function setPartyAddress(array $partyAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($partyAddressArrayErrorMessage = self::validatePartyAddressForArrayConstraintsFromSetPartyAddress($partyAddress))) {
            throw new \InvalidArgumentException($partyAddressArrayErrorMessage, __LINE__);
        }
        $this->PartyAddress = $partyAddress;
        return $this;
    }
    /**
     * Add item to PartyAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\PartyAddress $item
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public function addToPartyAddress(\StructType\PartyAddress $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PartyAddress) {
            throw new \InvalidArgumentException(sprintf('The PartyAddress property can only contain items of type \StructType\PartyAddress, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PartyAddress[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPurchaseOrderDetailResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
