<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetItemTypeInventoryRequest StructType
 * @subpackage Structs
 */
class GetItemTypeInventoryRequest extends AbstractStructBase
{
    /**
     * The SkuCode
     * @var string
     */
    public $SkuCode;
    /**
     * Constructor method for GetItemTypeInventoryRequest
     * @uses GetItemTypeInventoryRequest::setSkuCode()
     * @param string $skuCode
     */
    public function __construct($skuCode = null)
    {
        $this
            ->setSkuCode($skuCode);
    }
    /**
     * Get SkuCode value
     * @return string|null
     */
    public function getSkuCode()
    {
        return $this->SkuCode;
    }
    /**
     * Set SkuCode value
     * @param string $skuCode
     * @return \StructType\GetItemTypeInventoryRequest
     */
    public function setSkuCode($skuCode = null)
    {
        // validation for constraint: string
        if (!is_null($skuCode) && !is_string($skuCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($skuCode, true), gettype($skuCode)), __LINE__);
        }
        $this->SkuCode = $skuCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetItemTypeInventoryRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
