<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GRN StructType
 * @subpackage Structs
 */
class GRN extends AbstractStructBase
{
    /**
     * The VendorInvoiceNumber
     * @var string
     */
    public $VendorInvoiceNumber;
    /**
     * The VendorInvoiceDate
     * @var string
     */
    public $VendorInvoiceDate;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFields
     */
    public $CustomFields;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for GRN
     * @uses GRN::setVendorInvoiceNumber()
     * @uses GRN::setVendorInvoiceDate()
     * @uses GRN::setCustomFields()
     * @uses GRN::setCurrencyCode()
     * @param string $vendorInvoiceNumber
     * @param string $vendorInvoiceDate
     * @param \StructType\CustomFields $customFields
     * @param string $currencyCode
     */
    public function __construct($vendorInvoiceNumber = null, $vendorInvoiceDate = null, \StructType\CustomFields $customFields = null, $currencyCode = null)
    {
        $this
            ->setVendorInvoiceNumber($vendorInvoiceNumber)
            ->setVendorInvoiceDate($vendorInvoiceDate)
            ->setCustomFields($customFields)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get VendorInvoiceNumber value
     * @return string|null
     */
    public function getVendorInvoiceNumber()
    {
        return $this->VendorInvoiceNumber;
    }
    /**
     * Set VendorInvoiceNumber value
     * @param string $vendorInvoiceNumber
     * @return \StructType\GRN
     */
    public function setVendorInvoiceNumber($vendorInvoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vendorInvoiceNumber) && !is_string($vendorInvoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorInvoiceNumber, true), gettype($vendorInvoiceNumber)), __LINE__);
        }
        $this->VendorInvoiceNumber = $vendorInvoiceNumber;
        return $this;
    }
    /**
     * Get VendorInvoiceDate value
     * @return string|null
     */
    public function getVendorInvoiceDate()
    {
        return $this->VendorInvoiceDate;
    }
    /**
     * Set VendorInvoiceDate value
     * @param string $vendorInvoiceDate
     * @return \StructType\GRN
     */
    public function setVendorInvoiceDate($vendorInvoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($vendorInvoiceDate) && !is_string($vendorInvoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorInvoiceDate, true), gettype($vendorInvoiceDate)), __LINE__);
        }
        $this->VendorInvoiceDate = $vendorInvoiceDate;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \StructType\CustomFields|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \StructType\CustomFields $customFields
     * @return \StructType\GRN
     */
    public function setCustomFields(\StructType\CustomFields $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\GRN
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GRN
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
