<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacilityDTO StructType
 * @subpackage Structs
 */
class FacilityDTO extends AbstractStructBase
{
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The DisplayName
     * @var string
     */
    public $DisplayName;
    /**
     * The Enabled
     * @var bool
     */
    public $Enabled;
    /**
     * The TaxExempted
     * @var bool
     */
    public $TaxExempted;
    /**
     * The RetailInvoiceSequence
     * @var \StructType\WsSequence
     */
    public $RetailInvoiceSequence;
    /**
     * The TaxInvoiceSequence
     * @var \StructType\WsSequence
     */
    public $TaxInvoiceSequence;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Pan
     * @var string
     */
    public $Pan;
    /**
     * The Tin
     * @var string
     */
    public $Tin;
    /**
     * The CstNumber
     * @var string
     */
    public $CstNumber;
    /**
     * The StNumber
     * @var string
     */
    public $StNumber;
    /**
     * The Website
     * @var string
     */
    public $Website;
    /**
     * The LogoUrl
     * @var string
     */
    public $LogoUrl;
    /**
     * Constructor method for FacilityDTO
     * @uses FacilityDTO::setType()
     * @uses FacilityDTO::setDisplayName()
     * @uses FacilityDTO::setEnabled()
     * @uses FacilityDTO::setTaxExempted()
     * @uses FacilityDTO::setRetailInvoiceSequence()
     * @uses FacilityDTO::setTaxInvoiceSequence()
     * @uses FacilityDTO::setName()
     * @uses FacilityDTO::setCode()
     * @uses FacilityDTO::setPan()
     * @uses FacilityDTO::setTin()
     * @uses FacilityDTO::setCstNumber()
     * @uses FacilityDTO::setStNumber()
     * @uses FacilityDTO::setWebsite()
     * @uses FacilityDTO::setLogoUrl()
     * @param string $type
     * @param string $displayName
     * @param bool $enabled
     * @param bool $taxExempted
     * @param \StructType\WsSequence $retailInvoiceSequence
     * @param \StructType\WsSequence $taxInvoiceSequence
     * @param string $name
     * @param string $code
     * @param string $pan
     * @param string $tin
     * @param string $cstNumber
     * @param string $stNumber
     * @param string $website
     * @param string $logoUrl
     */
    public function __construct($type = null, $displayName = null, $enabled = null, $taxExempted = null, \StructType\WsSequence $retailInvoiceSequence = null, \StructType\WsSequence $taxInvoiceSequence = null, $name = null, $code = null, $pan = null, $tin = null, $cstNumber = null, $stNumber = null, $website = null, $logoUrl = null)
    {
        $this
            ->setType($type)
            ->setDisplayName($displayName)
            ->setEnabled($enabled)
            ->setTaxExempted($taxExempted)
            ->setRetailInvoiceSequence($retailInvoiceSequence)
            ->setTaxInvoiceSequence($taxInvoiceSequence)
            ->setName($name)
            ->setCode($code)
            ->setPan($pan)
            ->setTin($tin)
            ->setCstNumber($cstNumber)
            ->setStNumber($stNumber)
            ->setWebsite($website)
            ->setLogoUrl($logoUrl);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\FacilityDTO
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\FacilityDTO
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \StructType\FacilityDTO
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Get TaxExempted value
     * @return bool|null
     */
    public function getTaxExempted()
    {
        return $this->TaxExempted;
    }
    /**
     * Set TaxExempted value
     * @param bool $taxExempted
     * @return \StructType\FacilityDTO
     */
    public function setTaxExempted($taxExempted = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxExempted) && !is_bool($taxExempted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxExempted, true), gettype($taxExempted)), __LINE__);
        }
        $this->TaxExempted = $taxExempted;
        return $this;
    }
    /**
     * Get RetailInvoiceSequence value
     * @return \StructType\WsSequence|null
     */
    public function getRetailInvoiceSequence()
    {
        return $this->RetailInvoiceSequence;
    }
    /**
     * Set RetailInvoiceSequence value
     * @param \StructType\WsSequence $retailInvoiceSequence
     * @return \StructType\FacilityDTO
     */
    public function setRetailInvoiceSequence(\StructType\WsSequence $retailInvoiceSequence = null)
    {
        $this->RetailInvoiceSequence = $retailInvoiceSequence;
        return $this;
    }
    /**
     * Get TaxInvoiceSequence value
     * @return \StructType\WsSequence|null
     */
    public function getTaxInvoiceSequence()
    {
        return $this->TaxInvoiceSequence;
    }
    /**
     * Set TaxInvoiceSequence value
     * @param \StructType\WsSequence $taxInvoiceSequence
     * @return \StructType\FacilityDTO
     */
    public function setTaxInvoiceSequence(\StructType\WsSequence $taxInvoiceSequence = null)
    {
        $this->TaxInvoiceSequence = $taxInvoiceSequence;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\FacilityDTO
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\FacilityDTO
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Pan value
     * @return string|null
     */
    public function getPan()
    {
        return $this->Pan;
    }
    /**
     * Set Pan value
     * @param string $pan
     * @return \StructType\FacilityDTO
     */
    public function setPan($pan = null)
    {
        // validation for constraint: string
        if (!is_null($pan) && !is_string($pan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pan, true), gettype($pan)), __LINE__);
        }
        $this->Pan = $pan;
        return $this;
    }
    /**
     * Get Tin value
     * @return string|null
     */
    public function getTin()
    {
        return $this->Tin;
    }
    /**
     * Set Tin value
     * @param string $tin
     * @return \StructType\FacilityDTO
     */
    public function setTin($tin = null)
    {
        // validation for constraint: string
        if (!is_null($tin) && !is_string($tin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tin, true), gettype($tin)), __LINE__);
        }
        $this->Tin = $tin;
        return $this;
    }
    /**
     * Get CstNumber value
     * @return string|null
     */
    public function getCstNumber()
    {
        return $this->CstNumber;
    }
    /**
     * Set CstNumber value
     * @param string $cstNumber
     * @return \StructType\FacilityDTO
     */
    public function setCstNumber($cstNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cstNumber) && !is_string($cstNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cstNumber, true), gettype($cstNumber)), __LINE__);
        }
        $this->CstNumber = $cstNumber;
        return $this;
    }
    /**
     * Get StNumber value
     * @return string|null
     */
    public function getStNumber()
    {
        return $this->StNumber;
    }
    /**
     * Set StNumber value
     * @param string $stNumber
     * @return \StructType\FacilityDTO
     */
    public function setStNumber($stNumber = null)
    {
        // validation for constraint: string
        if (!is_null($stNumber) && !is_string($stNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stNumber, true), gettype($stNumber)), __LINE__);
        }
        $this->StNumber = $stNumber;
        return $this;
    }
    /**
     * Get Website value
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->Website;
    }
    /**
     * Set Website value
     * @param string $website
     * @return \StructType\FacilityDTO
     */
    public function setWebsite($website = null)
    {
        // validation for constraint: string
        if (!is_null($website) && !is_string($website)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($website, true), gettype($website)), __LINE__);
        }
        $this->Website = $website;
        return $this;
    }
    /**
     * Get LogoUrl value
     * @return string|null
     */
    public function getLogoUrl()
    {
        return $this->LogoUrl;
    }
    /**
     * Set LogoUrl value
     * @param string $logoUrl
     * @return \StructType\FacilityDTO
     */
    public function setLogoUrl($logoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($logoUrl) && !is_string($logoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logoUrl, true), gettype($logoUrl)), __LINE__);
        }
        $this->LogoUrl = $logoUrl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FacilityDTO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
