<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExportFilters StructType
 * @subpackage Structs
 */
class ExportFilters extends AbstractStructBase
{
    /**
     * The ExportFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ExportFilter[]
     */
    public $ExportFilter;
    /**
     * Constructor method for ExportFilters
     * @uses ExportFilters::setExportFilter()
     * @param \StructType\ExportFilter[] $exportFilter
     */
    public function __construct(array $exportFilter = array())
    {
        $this
            ->setExportFilter($exportFilter);
    }
    /**
     * Get ExportFilter value
     * @return \StructType\ExportFilter[]|null
     */
    public function getExportFilter()
    {
        return $this->ExportFilter;
    }
    /**
     * This method is responsible for validating the values passed to the setExportFilter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExportFilter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExportFilterForArrayConstraintsFromSetExportFilter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $exportFiltersExportFilterItem) {
            // validation for constraint: itemType
            if (!$exportFiltersExportFilterItem instanceof \StructType\ExportFilter) {
                $invalidValues[] = is_object($exportFiltersExportFilterItem) ? get_class($exportFiltersExportFilterItem) : sprintf('%s(%s)', gettype($exportFiltersExportFilterItem), var_export($exportFiltersExportFilterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExportFilter property can only contain items of type \StructType\ExportFilter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExportFilter value
     * @throws \InvalidArgumentException
     * @param \StructType\ExportFilter[] $exportFilter
     * @return \StructType\ExportFilters
     */
    public function setExportFilter(array $exportFilter = array())
    {
        // validation for constraint: array
        if ('' !== ($exportFilterArrayErrorMessage = self::validateExportFilterForArrayConstraintsFromSetExportFilter($exportFilter))) {
            throw new \InvalidArgumentException($exportFilterArrayErrorMessage, __LINE__);
        }
        $this->ExportFilter = $exportFilter;
        return $this;
    }
    /**
     * Add item to ExportFilter value
     * @throws \InvalidArgumentException
     * @param \StructType\ExportFilter $item
     * @return \StructType\ExportFilters
     */
    public function addToExportFilter(\StructType\ExportFilter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExportFilter) {
            throw new \InvalidArgumentException(sprintf('The ExportFilter property can only contain items of type \StructType\ExportFilter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExportFilter[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExportFilters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
