<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExportColumns StructType
 * @subpackage Structs
 */
class ExportColumns extends AbstractStructBase
{
    /**
     * The ExportColumn
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $ExportColumn;
    /**
     * Constructor method for ExportColumns
     * @uses ExportColumns::setExportColumn()
     * @param string[] $exportColumn
     */
    public function __construct(array $exportColumn = array())
    {
        $this
            ->setExportColumn($exportColumn);
    }
    /**
     * Get ExportColumn value
     * @return string[]|null
     */
    public function getExportColumn()
    {
        return $this->ExportColumn;
    }
    /**
     * This method is responsible for validating the values passed to the setExportColumn method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExportColumn method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExportColumnForArrayConstraintsFromSetExportColumn(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $exportColumnsExportColumnItem) {
            // validation for constraint: itemType
            if (!is_string($exportColumnsExportColumnItem)) {
                $invalidValues[] = is_object($exportColumnsExportColumnItem) ? get_class($exportColumnsExportColumnItem) : sprintf('%s(%s)', gettype($exportColumnsExportColumnItem), var_export($exportColumnsExportColumnItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExportColumn property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExportColumn value
     * @throws \InvalidArgumentException
     * @param string[] $exportColumn
     * @return \StructType\ExportColumns
     */
    public function setExportColumn(array $exportColumn = array())
    {
        // validation for constraint: array
        if ('' !== ($exportColumnArrayErrorMessage = self::validateExportColumnForArrayConstraintsFromSetExportColumn($exportColumn))) {
            throw new \InvalidArgumentException($exportColumnArrayErrorMessage, __LINE__);
        }
        $this->ExportColumn = $exportColumn;
        return $this;
    }
    /**
     * Add item to ExportColumn value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ExportColumns
     */
    public function addToExportColumn($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ExportColumn property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExportColumn[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExportColumns
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
