<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditGatePassRequest StructType
 * @subpackage Structs
 */
class EditGatePassRequest extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The WsGatePass
     * @var \StructType\WsGatePass
     */
    public $WsGatePass;
    /**
     * Constructor method for EditGatePassRequest
     * @uses EditGatePassRequest::setCode()
     * @uses EditGatePassRequest::setWsGatePass()
     * @param string $code
     * @param \StructType\WsGatePass $wsGatePass
     */
    public function __construct($code = null, \StructType\WsGatePass $wsGatePass = null)
    {
        $this
            ->setCode($code)
            ->setWsGatePass($wsGatePass);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\EditGatePassRequest
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get WsGatePass value
     * @return \StructType\WsGatePass|null
     */
    public function getWsGatePass()
    {
        return $this->WsGatePass;
    }
    /**
     * Set WsGatePass value
     * @param \StructType\WsGatePass $wsGatePass
     * @return \StructType\EditGatePassRequest
     */
    public function setWsGatePass(\StructType\WsGatePass $wsGatePass = null)
    {
        $this->WsGatePass = $wsGatePass;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditGatePassRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
