<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditFacilityResponse StructType
 * @subpackage Structs
 */
class EditFacilityResponse extends AbstractStructBase
{
    /**
     * The Successful
     * @var bool
     */
    public $Successful;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Errors
     */
    public $Errors;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Warnings
     */
    public $Warnings;
    /**
     * The Facility
     * @var \StructType\FacilityDTO
     */
    public $Facility;
    /**
     * The BillingAddress
     * @var \StructType\PartyAddressDTO
     */
    public $BillingAddress;
    /**
     * The ShippingAddress
     * @var \StructType\PartyAddressDTO
     */
    public $ShippingAddress;
    /**
     * Constructor method for EditFacilityResponse
     * @uses EditFacilityResponse::setSuccessful()
     * @uses EditFacilityResponse::setErrors()
     * @uses EditFacilityResponse::setWarnings()
     * @uses EditFacilityResponse::setFacility()
     * @uses EditFacilityResponse::setBillingAddress()
     * @uses EditFacilityResponse::setShippingAddress()
     * @param bool $successful
     * @param \StructType\Errors $errors
     * @param \StructType\Warnings $warnings
     * @param \StructType\FacilityDTO $facility
     * @param \StructType\PartyAddressDTO $billingAddress
     * @param \StructType\PartyAddressDTO $shippingAddress
     */
    public function __construct($successful = null, \StructType\Errors $errors = null, \StructType\Warnings $warnings = null, \StructType\FacilityDTO $facility = null, \StructType\PartyAddressDTO $billingAddress = null, \StructType\PartyAddressDTO $shippingAddress = null)
    {
        $this
            ->setSuccessful($successful)
            ->setErrors($errors)
            ->setWarnings($warnings)
            ->setFacility($facility)
            ->setBillingAddress($billingAddress)
            ->setShippingAddress($shippingAddress);
    }
    /**
     * Get Successful value
     * @return bool|null
     */
    public function getSuccessful()
    {
        return $this->Successful;
    }
    /**
     * Set Successful value
     * @param bool $successful
     * @return \StructType\EditFacilityResponse
     */
    public function setSuccessful($successful = null)
    {
        // validation for constraint: boolean
        if (!is_null($successful) && !is_bool($successful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successful, true), gettype($successful)), __LINE__);
        }
        $this->Successful = $successful;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\Errors|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\Errors $errors
     * @return \StructType\EditFacilityResponse
     */
    public function setErrors(\StructType\Errors $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\Warnings|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \StructType\Warnings $warnings
     * @return \StructType\EditFacilityResponse
     */
    public function setWarnings(\StructType\Warnings $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get Facility value
     * @return \StructType\FacilityDTO|null
     */
    public function getFacility()
    {
        return $this->Facility;
    }
    /**
     * Set Facility value
     * @param \StructType\FacilityDTO $facility
     * @return \StructType\EditFacilityResponse
     */
    public function setFacility(\StructType\FacilityDTO $facility = null)
    {
        $this->Facility = $facility;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return \StructType\PartyAddressDTO|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param \StructType\PartyAddressDTO $billingAddress
     * @return \StructType\EditFacilityResponse
     */
    public function setBillingAddress(\StructType\PartyAddressDTO $billingAddress = null)
    {
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \StructType\PartyAddressDTO|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \StructType\PartyAddressDTO $shippingAddress
     * @return \StructType\EditFacilityResponse
     */
    public function setShippingAddress(\StructType\PartyAddressDTO $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditFacilityResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
