<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateVendorDetailsRequest StructType
 * @subpackage Structs
 */
class CreateVendorDetailsRequest extends AbstractStructBase
{
    /**
     * The Vendor
     * @var \StructType\Vendor
     */
    public $Vendor;
    /**
     * The ShippingAddress
     * @var \StructType\PartyAddress
     */
    public $ShippingAddress;
    /**
     * The BillingAddress
     * @var \StructType\PartyAddress
     */
    public $BillingAddress;
    /**
     * The Contacts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Contacts
     */
    public $Contacts;
    /**
     * The Agreement
     * @var \StructType\VendorAgreement
     */
    public $Agreement;
    /**
     * Constructor method for CreateVendorDetailsRequest
     * @uses CreateVendorDetailsRequest::setVendor()
     * @uses CreateVendorDetailsRequest::setShippingAddress()
     * @uses CreateVendorDetailsRequest::setBillingAddress()
     * @uses CreateVendorDetailsRequest::setContacts()
     * @uses CreateVendorDetailsRequest::setAgreement()
     * @param \StructType\Vendor $vendor
     * @param \StructType\PartyAddress $shippingAddress
     * @param \StructType\PartyAddress $billingAddress
     * @param \StructType\Contacts $contacts
     * @param \StructType\VendorAgreement $agreement
     */
    public function __construct(\StructType\Vendor $vendor = null, \StructType\PartyAddress $shippingAddress = null, \StructType\PartyAddress $billingAddress = null, \StructType\Contacts $contacts = null, \StructType\VendorAgreement $agreement = null)
    {
        $this
            ->setVendor($vendor)
            ->setShippingAddress($shippingAddress)
            ->setBillingAddress($billingAddress)
            ->setContacts($contacts)
            ->setAgreement($agreement);
    }
    /**
     * Get Vendor value
     * @return \StructType\Vendor|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \StructType\Vendor $vendor
     * @return \StructType\CreateVendorDetailsRequest
     */
    public function setVendor(\StructType\Vendor $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \StructType\PartyAddress|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \StructType\PartyAddress $shippingAddress
     * @return \StructType\CreateVendorDetailsRequest
     */
    public function setShippingAddress(\StructType\PartyAddress $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return \StructType\PartyAddress|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param \StructType\PartyAddress $billingAddress
     * @return \StructType\CreateVendorDetailsRequest
     */
    public function setBillingAddress(\StructType\PartyAddress $billingAddress = null)
    {
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get Contacts value
     * @return \StructType\Contacts|null
     */
    public function getContacts()
    {
        return $this->Contacts;
    }
    /**
     * Set Contacts value
     * @param \StructType\Contacts $contacts
     * @return \StructType\CreateVendorDetailsRequest
     */
    public function setContacts(\StructType\Contacts $contacts = null)
    {
        $this->Contacts = $contacts;
        return $this;
    }
    /**
     * Get Agreement value
     * @return \StructType\VendorAgreement|null
     */
    public function getAgreement()
    {
        return $this->Agreement;
    }
    /**
     * Set Agreement value
     * @param \StructType\VendorAgreement $agreement
     * @return \StructType\CreateVendorDetailsRequest
     */
    public function setAgreement(\StructType\VendorAgreement $agreement = null)
    {
        $this->Agreement = $agreement;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateVendorDetailsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
