<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateReversePickupResponse StructType
 * @subpackage Structs
 */
class CreateReversePickupResponse extends AbstractStructBase
{
    /**
     * The ReversePickupCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReversePickupCode;
    /**
     * The SaleOrderItemCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SaleOrderItemCodes
     */
    public $SaleOrderItemCodes;
    /**
     * Constructor method for CreateReversePickupResponse
     * @uses CreateReversePickupResponse::setReversePickupCode()
     * @uses CreateReversePickupResponse::setSaleOrderItemCodes()
     * @param string $reversePickupCode
     * @param \StructType\SaleOrderItemCodes $saleOrderItemCodes
     */
    public function __construct($reversePickupCode = null, \StructType\SaleOrderItemCodes $saleOrderItemCodes = null)
    {
        $this
            ->setReversePickupCode($reversePickupCode)
            ->setSaleOrderItemCodes($saleOrderItemCodes);
    }
    /**
     * Get ReversePickupCode value
     * @return string|null
     */
    public function getReversePickupCode()
    {
        return $this->ReversePickupCode;
    }
    /**
     * Set ReversePickupCode value
     * @param string $reversePickupCode
     * @return \StructType\CreateReversePickupResponse
     */
    public function setReversePickupCode($reversePickupCode = null)
    {
        // validation for constraint: string
        if (!is_null($reversePickupCode) && !is_string($reversePickupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reversePickupCode, true), gettype($reversePickupCode)), __LINE__);
        }
        $this->ReversePickupCode = $reversePickupCode;
        return $this;
    }
    /**
     * Get SaleOrderItemCodes value
     * @return \StructType\SaleOrderItemCodes|null
     */
    public function getSaleOrderItemCodes()
    {
        return $this->SaleOrderItemCodes;
    }
    /**
     * Set SaleOrderItemCodes value
     * @param \StructType\SaleOrderItemCodes $saleOrderItemCodes
     * @return \StructType\CreateReversePickupResponse
     */
    public function setSaleOrderItemCodes(\StructType\SaleOrderItemCodes $saleOrderItemCodes = null)
    {
        $this->SaleOrderItemCodes = $saleOrderItemCodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateReversePickupResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
