<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateInvoiceAndAllocateShippingProviderRequest StructType
 * @subpackage Structs
 */
class CreateInvoiceAndAllocateShippingProviderRequest extends AbstractStructBase
{
    /**
     * The ShippingPackageCode
     * @var string
     */
    public $ShippingPackageCode;
    /**
     * Constructor method for CreateInvoiceAndAllocateShippingProviderRequest
     * @uses CreateInvoiceAndAllocateShippingProviderRequest::setShippingPackageCode()
     * @param string $shippingPackageCode
     */
    public function __construct($shippingPackageCode = null)
    {
        $this
            ->setShippingPackageCode($shippingPackageCode);
    }
    /**
     * Get ShippingPackageCode value
     * @return string|null
     */
    public function getShippingPackageCode()
    {
        return $this->ShippingPackageCode;
    }
    /**
     * Set ShippingPackageCode value
     * @param string $shippingPackageCode
     * @return \StructType\CreateInvoiceAndAllocateShippingProviderRequest
     */
    public function setShippingPackageCode($shippingPackageCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingPackageCode) && !is_string($shippingPackageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingPackageCode, true), gettype($shippingPackageCode)), __LINE__);
        }
        $this->ShippingPackageCode = $shippingPackageCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateInvoiceAndAllocateShippingProviderRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
