<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BackOrderItem StructType
 * @subpackage Structs
 */
class BackOrderItem extends AbstractStructBase
{
    /**
     * The SkuCode
     * @var string
     */
    public $SkuCode;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The PageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PageUrl;
    /**
     * The ImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImageUrl;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The Color
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Color;
    /**
     * The Brand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Brand;
    /**
     * The Size
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Size;
    /**
     * Constructor method for BackOrderItem
     * @uses BackOrderItem::setSkuCode()
     * @uses BackOrderItem::setName()
     * @uses BackOrderItem::setPageUrl()
     * @uses BackOrderItem::setImageUrl()
     * @uses BackOrderItem::setQuantity()
     * @uses BackOrderItem::setColor()
     * @uses BackOrderItem::setBrand()
     * @uses BackOrderItem::setSize()
     * @param string $skuCode
     * @param string $name
     * @param string $pageUrl
     * @param string $imageUrl
     * @param int $quantity
     * @param string $color
     * @param string $brand
     * @param string $size
     */
    public function __construct($skuCode = null, $name = null, $pageUrl = null, $imageUrl = null, $quantity = null, $color = null, $brand = null, $size = null)
    {
        $this
            ->setSkuCode($skuCode)
            ->setName($name)
            ->setPageUrl($pageUrl)
            ->setImageUrl($imageUrl)
            ->setQuantity($quantity)
            ->setColor($color)
            ->setBrand($brand)
            ->setSize($size);
    }
    /**
     * Get SkuCode value
     * @return string|null
     */
    public function getSkuCode()
    {
        return $this->SkuCode;
    }
    /**
     * Set SkuCode value
     * @param string $skuCode
     * @return \StructType\BackOrderItem
     */
    public function setSkuCode($skuCode = null)
    {
        // validation for constraint: string
        if (!is_null($skuCode) && !is_string($skuCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($skuCode, true), gettype($skuCode)), __LINE__);
        }
        $this->SkuCode = $skuCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\BackOrderItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PageUrl value
     * @return string|null
     */
    public function getPageUrl()
    {
        return $this->PageUrl;
    }
    /**
     * Set PageUrl value
     * @param string $pageUrl
     * @return \StructType\BackOrderItem
     */
    public function setPageUrl($pageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($pageUrl) && !is_string($pageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pageUrl, true), gettype($pageUrl)), __LINE__);
        }
        $this->PageUrl = $pageUrl;
        return $this;
    }
    /**
     * Get ImageUrl value
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->ImageUrl;
    }
    /**
     * Set ImageUrl value
     * @param string $imageUrl
     * @return \StructType\BackOrderItem
     */
    public function setImageUrl($imageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($imageUrl) && !is_string($imageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageUrl, true), gettype($imageUrl)), __LINE__);
        }
        $this->ImageUrl = $imageUrl;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\BackOrderItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @param string $color
     * @return \StructType\BackOrderItem
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        $this->Color = $color;
        return $this;
    }
    /**
     * Get Brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param string $brand
     * @return \StructType\BackOrderItem
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Get Size value
     * @return string|null
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param string $size
     * @return \StructType\BackOrderItem
     */
    public function setSize($size = null)
    {
        // validation for constraint: string
        if (!is_null($size) && !is_string($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->Size = $size;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BackOrderItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
