<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AsnItems StructType
 * @subpackage Structs
 */
class AsnItems extends AbstractStructBase
{
    /**
     * The AsnItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AsnItem[]
     */
    public $AsnItem;
    /**
     * Constructor method for AsnItems
     * @uses AsnItems::setAsnItem()
     * @param \StructType\AsnItem[] $asnItem
     */
    public function __construct(array $asnItem = array())
    {
        $this
            ->setAsnItem($asnItem);
    }
    /**
     * Get AsnItem value
     * @return \StructType\AsnItem[]|null
     */
    public function getAsnItem()
    {
        return $this->AsnItem;
    }
    /**
     * This method is responsible for validating the values passed to the setAsnItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsnItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsnItemForArrayConstraintsFromSetAsnItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asnItemsAsnItemItem) {
            // validation for constraint: itemType
            if (!$asnItemsAsnItemItem instanceof \StructType\AsnItem) {
                $invalidValues[] = is_object($asnItemsAsnItemItem) ? get_class($asnItemsAsnItemItem) : sprintf('%s(%s)', gettype($asnItemsAsnItemItem), var_export($asnItemsAsnItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AsnItem property can only contain items of type \StructType\AsnItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AsnItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AsnItem[] $asnItem
     * @return \StructType\AsnItems
     */
    public function setAsnItem(array $asnItem = array())
    {
        // validation for constraint: array
        if ('' !== ($asnItemArrayErrorMessage = self::validateAsnItemForArrayConstraintsFromSetAsnItem($asnItem))) {
            throw new \InvalidArgumentException($asnItemArrayErrorMessage, __LINE__);
        }
        $this->AsnItem = $asnItem;
        return $this;
    }
    /**
     * Add item to AsnItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AsnItem $item
     * @return \StructType\AsnItems
     */
    public function addToAsnItem(\StructType\AsnItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AsnItem) {
            throw new \InvalidArgumentException(sprintf('The AsnItem property can only contain items of type \StructType\AsnItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AsnItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AsnItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
