<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddPurchaseOrderItemsRequest StructType
 * @subpackage Structs
 */
class AddPurchaseOrderItemsRequest extends AbstractStructBase
{
    /**
     * The PurchaseOrderCode
     * @var string
     */
    public $PurchaseOrderCode;
    /**
     * The PurchaseOrderItems
     * @var \StructType\PurchaseOrderItems
     */
    public $PurchaseOrderItems;
    /**
     * Constructor method for AddPurchaseOrderItemsRequest
     * @uses AddPurchaseOrderItemsRequest::setPurchaseOrderCode()
     * @uses AddPurchaseOrderItemsRequest::setPurchaseOrderItems()
     * @param string $purchaseOrderCode
     * @param \StructType\PurchaseOrderItems $purchaseOrderItems
     */
    public function __construct($purchaseOrderCode = null, \StructType\PurchaseOrderItems $purchaseOrderItems = null)
    {
        $this
            ->setPurchaseOrderCode($purchaseOrderCode)
            ->setPurchaseOrderItems($purchaseOrderItems);
    }
    /**
     * Get PurchaseOrderCode value
     * @return string|null
     */
    public function getPurchaseOrderCode()
    {
        return $this->PurchaseOrderCode;
    }
    /**
     * Set PurchaseOrderCode value
     * @param string $purchaseOrderCode
     * @return \StructType\AddPurchaseOrderItemsRequest
     */
    public function setPurchaseOrderCode($purchaseOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderCode) && !is_string($purchaseOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderCode, true), gettype($purchaseOrderCode)), __LINE__);
        }
        $this->PurchaseOrderCode = $purchaseOrderCode;
        return $this;
    }
    /**
     * Get PurchaseOrderItems value
     * @return \StructType\PurchaseOrderItems|null
     */
    public function getPurchaseOrderItems()
    {
        return $this->PurchaseOrderItems;
    }
    /**
     * Set PurchaseOrderItems value
     * @param \StructType\PurchaseOrderItems $purchaseOrderItems
     * @return \StructType\AddPurchaseOrderItemsRequest
     */
    public function setPurchaseOrderItems(\StructType\PurchaseOrderItems $purchaseOrderItems = null)
    {
        $this->PurchaseOrderItems = $purchaseOrderItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddPurchaseOrderItemsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
