<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddOrEditItemLabelsRequest StructType
 * @subpackage Structs
 */
class AddOrEditItemLabelsRequest extends AbstractStructBase
{
    /**
     * The ItemSKUCode
     * @var string
     */
    public $ItemSKUCode;
    /**
     * The ItemCodes
     * @var \StructType\ItemCodes
     */
    public $ItemCodes;
    /**
     * Constructor method for AddOrEditItemLabelsRequest
     * @uses AddOrEditItemLabelsRequest::setItemSKUCode()
     * @uses AddOrEditItemLabelsRequest::setItemCodes()
     * @param string $itemSKUCode
     * @param \StructType\ItemCodes $itemCodes
     */
    public function __construct($itemSKUCode = null, \StructType\ItemCodes $itemCodes = null)
    {
        $this
            ->setItemSKUCode($itemSKUCode)
            ->setItemCodes($itemCodes);
    }
    /**
     * Get ItemSKUCode value
     * @return string|null
     */
    public function getItemSKUCode()
    {
        return $this->ItemSKUCode;
    }
    /**
     * Set ItemSKUCode value
     * @param string $itemSKUCode
     * @return \StructType\AddOrEditItemLabelsRequest
     */
    public function setItemSKUCode($itemSKUCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemSKUCode) && !is_string($itemSKUCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSKUCode, true), gettype($itemSKUCode)), __LINE__);
        }
        $this->ItemSKUCode = $itemSKUCode;
        return $this;
    }
    /**
     * Get ItemCodes value
     * @return \StructType\ItemCodes|null
     */
    public function getItemCodes()
    {
        return $this->ItemCodes;
    }
    /**
     * Set ItemCodes value
     * @param \StructType\ItemCodes $itemCodes
     * @return \StructType\AddOrEditItemLabelsRequest
     */
    public function setItemCodes(\StructType\ItemCodes $itemCodes = null)
    {
        $this->ItemCodes = $itemCodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddOrEditItemLabelsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
