<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptSaleOrderItemAlternateRequest StructType
 * @subpackage Structs
 */
class AcceptSaleOrderItemAlternateRequest extends AbstractStructBase
{
    /**
     * The SelectedAlternateItemSKU
     * @var string
     */
    public $SelectedAlternateItemSKU;
    /**
     * The SaleOrderCode
     * @var string
     */
    public $SaleOrderCode;
    /**
     * The SaleOrderItems
     * @var \StructType\SaleOrderItems
     */
    public $SaleOrderItems;
    /**
     * Constructor method for AcceptSaleOrderItemAlternateRequest
     * @uses AcceptSaleOrderItemAlternateRequest::setSelectedAlternateItemSKU()
     * @uses AcceptSaleOrderItemAlternateRequest::setSaleOrderCode()
     * @uses AcceptSaleOrderItemAlternateRequest::setSaleOrderItems()
     * @param string $selectedAlternateItemSKU
     * @param string $saleOrderCode
     * @param \StructType\SaleOrderItems $saleOrderItems
     */
    public function __construct($selectedAlternateItemSKU = null, $saleOrderCode = null, \StructType\SaleOrderItems $saleOrderItems = null)
    {
        $this
            ->setSelectedAlternateItemSKU($selectedAlternateItemSKU)
            ->setSaleOrderCode($saleOrderCode)
            ->setSaleOrderItems($saleOrderItems);
    }
    /**
     * Get SelectedAlternateItemSKU value
     * @return string|null
     */
    public function getSelectedAlternateItemSKU()
    {
        return $this->SelectedAlternateItemSKU;
    }
    /**
     * Set SelectedAlternateItemSKU value
     * @param string $selectedAlternateItemSKU
     * @return \StructType\AcceptSaleOrderItemAlternateRequest
     */
    public function setSelectedAlternateItemSKU($selectedAlternateItemSKU = null)
    {
        // validation for constraint: string
        if (!is_null($selectedAlternateItemSKU) && !is_string($selectedAlternateItemSKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedAlternateItemSKU, true), gettype($selectedAlternateItemSKU)), __LINE__);
        }
        $this->SelectedAlternateItemSKU = $selectedAlternateItemSKU;
        return $this;
    }
    /**
     * Get SaleOrderCode value
     * @return string|null
     */
    public function getSaleOrderCode()
    {
        return $this->SaleOrderCode;
    }
    /**
     * Set SaleOrderCode value
     * @param string $saleOrderCode
     * @return \StructType\AcceptSaleOrderItemAlternateRequest
     */
    public function setSaleOrderCode($saleOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderCode) && !is_string($saleOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderCode, true), gettype($saleOrderCode)), __LINE__);
        }
        $this->SaleOrderCode = $saleOrderCode;
        return $this;
    }
    /**
     * Get SaleOrderItems value
     * @return \StructType\SaleOrderItems|null
     */
    public function getSaleOrderItems()
    {
        return $this->SaleOrderItems;
    }
    /**
     * Set SaleOrderItems value
     * @param \StructType\SaleOrderItems $saleOrderItems
     * @return \StructType\AcceptSaleOrderItemAlternateRequest
     */
    public function setSaleOrderItems(\StructType\SaleOrderItems $saleOrderItems = null)
    {
        $this->SaleOrderItems = $saleOrderItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AcceptSaleOrderItemAlternateRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
