<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unhold ServiceType
 * @subpackage Services
 */
class Unhold extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UnholdSaleOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UnholdSaleOrderRequest $unholdSaleOrderRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function UnholdSaleOrder(\StructType\UnholdSaleOrderRequest $unholdSaleOrderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->UnholdSaleOrder($unholdSaleOrderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnholdSaleOrderItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UnholdSaleOrderItemsRequest $unholdSaleOrderItemsRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function UnholdSaleOrderItems(\StructType\UnholdSaleOrderItemsRequest $unholdSaleOrderItemsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->UnholdSaleOrderItems($unholdSaleOrderItemsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
