<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Receive ServiceType
 * @subpackage Services
 */
class Receive extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReceiveReversePickupFromRetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReceiveReversePickupFromRetailRequest $receiveReversePickupFromRetailRequest
     * @return \StructType\ReceiveReversePickupFromRetailResponse|bool
     */
    public function ReceiveReversePickupFromRetail(\StructType\ReceiveReversePickupFromRetailRequest $receiveReversePickupFromRetailRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->ReceiveReversePickupFromRetail($receiveReversePickupFromRetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReceiveReversePickupFromRetailResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
