<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Pick ServiceType
 * @subpackage Services
 */
class Pick extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PickShippingPackage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PickShippingPackageRequest $pickShippingPackageRequest
     * @return \StructType\PickShippingPackageResponse|bool
     */
    public function PickShippingPackage(\StructType\PickShippingPackageRequest $pickShippingPackageRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->PickShippingPackage($pickShippingPackageRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PickShippingPackageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
