<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetItemTypeDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItemTypeDetailRequest $getItemTypeDetailRequest
     * @return \StructType\GetItemTypeDetailResponse|bool
     */
    public function GetItemTypeDetail(\StructType\GetItemTypeDetailRequest $getItemTypeDetailRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetItemTypeDetail($getItemTypeDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTaxTypeConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTaxTypeConfigurationRequest $getTaxTypeConfigurationRequest
     * @return \StructType\GetTaxTypeConfigurationResponse|bool
     */
    public function GetTaxTypeConfiguration(\StructType\GetTaxTypeConfigurationRequest $getTaxTypeConfigurationRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTaxTypeConfiguration($getTaxTypeConfigurationRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPurchaseOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPurchaseOrdersRequest $getPurchaseOrdersRequest
     * @return \StructType\GetPurchaseOrdersResponse|bool
     */
    public function GetPurchaseOrders(\StructType\GetPurchaseOrdersRequest $getPurchaseOrdersRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPurchaseOrders($getPurchaseOrdersRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBackOrderItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBackOrderItemsRequest $getBackOrderItemsRequest
     * @return \StructType\GetBackOrderItemsResponse|bool
     */
    public function GetBackOrderItems(\StructType\GetBackOrderItemsRequest $getBackOrderItemsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBackOrderItems($getBackOrderItemsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetExportJobStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetExportJobStatusRequest $getExportJobStatusRequest
     * @return \StructType\GetExportJobStatusResponse|bool
     */
    public function GetExportJobStatus(\StructType\GetExportJobStatusRequest $getExportJobStatusRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetExportJobStatus($getExportJobStatusRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetItemDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItemDetailRequest $getItemDetailRequest
     * @return \StructType\GetItemDetailResponse|bool
     */
    public function GetItemDetail(\StructType\GetItemDetailRequest $getItemDetailRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetItemDetail($getItemDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInventorySnapshot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInventorySnapshotRequest $getInventorySnapshotRequest
     * @return \StructType\GetInventorySnapshotResponse|bool
     */
    public function GetInventorySnapshot(\StructType\GetInventorySnapshotRequest $getInventorySnapshotRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInventorySnapshot($getInventorySnapshotRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetItemTypeInventory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItemTypeInventoryRequest $getItemTypeInventoryRequest
     * @return \StructType\GetItemTypeInventoryResponse|bool
     */
    public function GetItemTypeInventory(\StructType\GetItemTypeInventoryRequest $getItemTypeInventoryRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetItemTypeInventory($getItemTypeInventoryRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetServiceability
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServiceabilityRequest $getServiceabilityRequest
     * @return \StructType\GetServiceabilityResponse|bool
     */
    public function GetServiceability(\StructType\GetServiceabilityRequest $getServiceabilityRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetServiceability($getServiceabilityRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSaleOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSaleOrderRequest $getSaleOrderRequest
     * @return \StructType\GetSaleOrderResponse|bool
     */
    public function GetSaleOrder(\StructType\GetSaleOrderRequest $getSaleOrderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSaleOrder($getSaleOrderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInflowReceiptDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInflowReceiptDetailRequest $getInflowReceiptDetailRequest
     * @return \StructType\GetInflowReceiptDetailResponse|bool
     */
    public function GetInflowReceiptDetail(\StructType\GetInflowReceiptDetailRequest $getInflowReceiptDetailRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInflowReceiptDetail($getInflowReceiptDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVendorItemTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVendorItemTypesRequest $getVendorItemTypesRequest
     * @return \StructType\GetVendorItemTypesResponse|bool
     */
    public function GetVendorItemTypes(\StructType\GetVendorItemTypesRequest $getVendorItemTypesRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVendorItemTypes($getVendorItemTypesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPurchaseOrderDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPurchaseOrderDetailRequest $getPurchaseOrderDetailRequest
     * @return \StructType\GetPurchaseOrderDetailResponse|bool
     */
    public function GetPurchaseOrderDetail(\StructType\GetPurchaseOrderDetailRequest $getPurchaseOrderDetailRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPurchaseOrderDetail($getPurchaseOrderDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetShippingManifest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShippingManifestRequest $getShippingManifestRequest
     * @return \StructType\GetShippingManifestResponse|bool
     */
    public function GetShippingManifest(\StructType\GetShippingManifestRequest $getShippingManifestRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetShippingManifest($getShippingManifestRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInflowReceipts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInflowReceiptsRequest $getInflowReceiptsRequest
     * @return \StructType\GetInflowReceiptsResponse|bool
     */
    public function GetInflowReceipts(\StructType\GetInflowReceiptsRequest $getInflowReceiptsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInflowReceipts($getInflowReceiptsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetBackOrderItemsResponse|\StructType\GetExportJobStatusResponse|\StructType\GetInflowReceiptDetailResponse|\StructType\GetInflowReceiptsResponse|\StructType\GetInventorySnapshotResponse|\StructType\GetItemDetailResponse|\StructType\GetItemTypeDetailResponse|\StructType\GetItemTypeInventoryResponse|\StructType\GetPurchaseOrderDetailResponse|\StructType\GetPurchaseOrdersResponse|\StructType\GetSaleOrderResponse|\StructType\GetServiceabilityResponse|\StructType\GetShippingManifestResponse|\StructType\GetTaxTypeConfigurationResponse|\StructType\GetVendorItemTypesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
