<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Edit ServiceType
 * @subpackage Services
 */
class Edit extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EditSaleOrderItemMetadata
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditSaleOrderItemMetadataRequest $editSaleOrderItemMetadataRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function EditSaleOrderItemMetadata(\StructType\EditSaleOrderItemMetadataRequest $editSaleOrderItemMetadataRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->EditSaleOrderItemMetadata($editSaleOrderItemMetadataRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditShippingPackage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditShippingPackageRequest $editShippingPackageRequest
     * @return \StructType\EditShippingPackageResponse|bool
     */
    public function EditShippingPackage(\StructType\EditShippingPackageRequest $editShippingPackageRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->EditShippingPackage($editShippingPackageRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditItemType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ItemTypeRequest $editItemTypeRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function EditItemType(\StructType\ItemTypeRequest $editItemTypeRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->EditItemType($editItemTypeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditVendorItemType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VendorItemType $editVendorItemTypeRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function EditVendorItemType(\StructType\VendorItemType $editVendorItemTypeRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->EditVendorItemType($editVendorItemTypeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditSaleOrderMetadata
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditSaleOrderMetadataRequest $editSaleOrderMetadataRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function EditSaleOrderMetadata(\StructType\EditSaleOrderMetadataRequest $editSaleOrderMetadataRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->EditSaleOrderMetadata($editSaleOrderMetadataRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditVendorDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditVendorDetailsRequest $editVendorDetailsRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function EditVendorDetails(\StructType\EditVendorDetailsRequest $editVendorDetailsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->EditVendorDetails($editVendorDetailsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditSaleOrderAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditSaleOrderAddressRequest $editSaleOrderAddressRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function EditSaleOrderAddress(\StructType\EditSaleOrderAddressRequest $editSaleOrderAddressRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->EditSaleOrderAddress($editSaleOrderAddressRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditCustomerRequest $editCustomerRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function EditCustomer(\StructType\EditCustomerRequest $editCustomerRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->EditCustomer($editCustomerRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditGatePass
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditGatePassRequest $editGatePassRequest
     * @return \StructType\EditGatePassResponse|bool
     */
    public function EditGatePass(\StructType\EditGatePassRequest $editGatePassRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->EditGatePass($editGatePassRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditFacility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditFacilityRequest $editFacilityRequest
     * @return \StructType\EditFacilityResponse|bool
     */
    public function EditFacility(\StructType\EditFacilityRequest $editFacilityRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->EditFacility($editFacilityRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditScriptConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditScriptConfigRequest $editScriptConfigRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function EditScriptConfig(\StructType\EditScriptConfigRequest $editScriptConfigRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->EditScriptConfig($editScriptConfigRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EditFacilityResponse|\StructType\EditGatePassResponse|\StructType\EditShippingPackageResponse|\StructType\ServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
