<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateSaleOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateSaleOrderRequest $createSaleOrderRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function CreateSaleOrder(\StructType\CreateSaleOrderRequest $createSaleOrderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateSaleOrder($createSaleOrderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateGatePass
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateGatePassRequest $createGatePassRequest
     * @return \StructType\CreateGatePassResponse|bool
     */
    public function CreateGatePass(\StructType\CreateGatePassRequest $createGatePassRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateGatePass($createGatePassRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateCustomerRequest $createCustomerRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function CreateCustomer(\StructType\CreateCustomerRequest $createCustomerRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateCustomer($createCustomerRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateFacility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateFacilityRequest $createFacilityRequest
     * @return \StructType\CreateFacilityResponse|bool
     */
    public function CreateFacility(\StructType\CreateFacilityRequest $createFacilityRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateFacility($createFacilityRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrEditVendor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Vendor $createOrEditVendorRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function CreateOrEditVendor(\StructType\Vendor $createOrEditVendorRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOrEditVendor($createOrEditVendorRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrEditVendorItemType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VendorItemType $createOrEditVendorItemTypeRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function CreateOrEditVendorItemType(\StructType\VendorItemType $createOrEditVendorItemTypeRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOrEditVendorItemType($createOrEditVendorItemTypeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateSaleOrderItemAlternate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateSaleOrderItemAlternateRequest $createSaleOrderItemAlternateRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function CreateSaleOrderItemAlternate(\StructType\CreateSaleOrderItemAlternateRequest $createSaleOrderItemAlternateRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateSaleOrderItemAlternate($createSaleOrderItemAlternateRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateVendorItemType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VendorItemType $createVendorItemTypeRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function CreateVendorItemType(\StructType\VendorItemType $createVendorItemTypeRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateVendorItemType($createVendorItemTypeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateASN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateASNRequest $createASNRequest
     * @return \StructType\CreateASNResponse|bool
     */
    public function CreateASN(\StructType\CreateASNRequest $createASNRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateASN($createASNRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateExportJob
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateExportJobRequest $createExportJobRequest
     * @return \StructType\CreateExportJobResponse|bool
     */
    public function CreateExportJob(\StructType\CreateExportJobRequest $createExportJobRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateExportJob($createExportJobRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrEditItemType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ItemTypeRequest $createOrEditItemTypeRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function CreateOrEditItemType(\StructType\ItemTypeRequest $createOrEditItemTypeRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOrEditItemType($createOrEditItemTypeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateItemType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ItemTypeRequest $createItemTypeRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function CreateItemType(\StructType\ItemTypeRequest $createItemTypeRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateItemType($createItemTypeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateReversePickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateReversePickupRequest $createReversePickupRequest
     * @return \StructType\CreateReversePickupResponse|bool
     */
    public function CreateReversePickup(\StructType\CreateReversePickupRequest $createReversePickupRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateReversePickup($createReversePickupRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrEditCategory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrEditCategoryRequest $createOrEditCategoryRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function CreateOrEditCategory(\StructType\CreateOrEditCategoryRequest $createOrEditCategoryRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOrEditCategory($createOrEditCategoryRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePurchaseOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePurchaseOrderRequest $createPurchaseOrderRequest
     * @return \StructType\CreatePurchaseOrderResponse|bool
     */
    public function CreatePurchaseOrder(\StructType\CreatePurchaseOrderRequest $createPurchaseOrderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePurchaseOrder($createPurchaseOrderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * CreateInvoiceAndAllocateShippingProvider
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateInvoiceAndAllocateShippingProviderRequest $createInvoiceAndAllocateShippingProviderRequest
     * @return \StructType\CreateInvoiceAndAllocateShippingProviderResponse|bool
     */
    public function CreateInvoiceAndAllocateShippingProvider(\StructType\CreateInvoiceAndAllocateShippingProviderRequest $createInvoiceAndAllocateShippingProviderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateInvoiceAndAllocateShippingProvider($createInvoiceAndAllocateShippingProviderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateInflowReceipt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateInflowReceiptRequest $createInflowReceiptRequest
     * @return \StructType\CreateInflowReceiptResponse|bool
     */
    public function CreateInflowReceipt(\StructType\CreateInflowReceiptRequest $createInflowReceiptRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateInflowReceipt($createInflowReceiptRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrEditFacilityItemType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrEditFacilityItemTypeRequest $createOrEditFacilityItemTypeRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function CreateOrEditFacilityItemType(\StructType\CreateOrEditFacilityItemTypeRequest $createOrEditFacilityItemTypeRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOrEditFacilityItemType($createOrEditFacilityItemTypeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateApprovedPurchaseOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateApprovedPurchaseOrderRequest $createApprovedPurchaseOrderRequest
     * @return \StructType\CreateApprovedPurchaseOrderResponse|bool
     */
    public function CreateApprovedPurchaseOrder(\StructType\CreateApprovedPurchaseOrderRequest $createApprovedPurchaseOrderRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateApprovedPurchaseOrder($createApprovedPurchaseOrderRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateVendorCreditInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateVendorCreditInvoiceRequest $createVendorCreditInvoiceRequest
     * @return \StructType\CreateVendorCreditInvoiceResponse|bool
     */
    public function CreateVendorCreditInvoice(\StructType\CreateVendorCreditInvoiceRequest $createVendorCreditInvoiceRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateVendorCreditInvoice($createVendorCreditInvoiceRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateVendorDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateVendorDetailsRequest $createVendorDetailsRequest
     * @return \StructType\ServiceResponse|bool
     */
    public function CreateVendorDetails(\StructType\CreateVendorDetailsRequest $createVendorDetailsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateVendorDetails($createVendorDetailsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateApprovedPurchaseOrderResponse|\StructType\CreateASNResponse|\StructType\CreateExportJobResponse|\StructType\CreateFacilityResponse|\StructType\CreateGatePassResponse|\StructType\CreateInflowReceiptResponse|\StructType\CreateInvoiceAndAllocateShippingProviderResponse|\StructType\CreatePurchaseOrderResponse|\StructType\CreateReversePickupResponse|\StructType\CreateVendorCreditInvoiceResponse|\StructType\ServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
