<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Auto ServiceType
 * @subpackage Services
 */
class Auto extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AutoCompletePutaway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AutoCompletePutawayRequest $autoCompletePutawayRequest
     * @return \StructType\AutoCompletePutawayResponse|bool
     */
    public function AutoCompletePutaway(\StructType\AutoCompletePutawayRequest $autoCompletePutawayRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->AutoCompletePutaway($autoCompletePutawayRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AutoCompletePutawayResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
