<?php

namespace EnumType;

/**
 * This class stands for ShippingMethodCode EnumType
 * @subpackage Enumerations
 */
class ShippingMethodCode
{
    /**
     * Constant for value 'STD'
     * @return string 'STD'
     */
    const VALUE_STD = 'STD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
