<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WsSequence StructType
 * @subpackage Structs
 */
class WsSequence extends AbstractStructBase
{
    /**
     * The Prefix
     * @var string
     */
    public $Prefix;
    /**
     * The CurrentValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CurrentValue;
    /**
     * Constructor method for WsSequence
     * @uses WsSequence::setPrefix()
     * @uses WsSequence::setCurrentValue()
     * @param string $prefix
     * @param int $currentValue
     */
    public function __construct($prefix = null, $currentValue = null)
    {
        $this
            ->setPrefix($prefix)
            ->setCurrentValue($currentValue);
    }
    /**
     * Get Prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->Prefix;
    }
    /**
     * Set Prefix value
     * @param string $prefix
     * @return \StructType\WsSequence
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefix, true), gettype($prefix)), __LINE__);
        }
        $this->Prefix = $prefix;
        return $this;
    }
    /**
     * Get CurrentValue value
     * @return int|null
     */
    public function getCurrentValue()
    {
        return $this->CurrentValue;
    }
    /**
     * Set CurrentValue value
     * @param int $currentValue
     * @return \StructType\WsSequence
     */
    public function setCurrentValue($currentValue = null)
    {
        // validation for constraint: int
        if (!is_null($currentValue) && !(is_int($currentValue) || ctype_digit($currentValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentValue, true), gettype($currentValue)), __LINE__);
        }
        $this->CurrentValue = $currentValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WsSequence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
