<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WsGatePass StructType
 * @subpackage Structs
 */
class WsGatePass extends AbstractStructBase
{
    /**
     * The Purpose
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Purpose;
    /**
     * The TransferAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TransferAmount;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFields
     */
    public $CustomFields;
    /**
     * Constructor method for WsGatePass
     * @uses WsGatePass::setPurpose()
     * @uses WsGatePass::setTransferAmount()
     * @uses WsGatePass::setReferenceNumber()
     * @uses WsGatePass::setCustomFields()
     * @param string $purpose
     * @param float $transferAmount
     * @param string $referenceNumber
     * @param \StructType\CustomFields $customFields
     */
    public function __construct($purpose = null, $transferAmount = null, $referenceNumber = null, \StructType\CustomFields $customFields = null)
    {
        $this
            ->setPurpose($purpose)
            ->setTransferAmount($transferAmount)
            ->setReferenceNumber($referenceNumber)
            ->setCustomFields($customFields);
    }
    /**
     * Get Purpose value
     * @return string|null
     */
    public function getPurpose()
    {
        return $this->Purpose;
    }
    /**
     * Set Purpose value
     * @param string $purpose
     * @return \StructType\WsGatePass
     */
    public function setPurpose($purpose = null)
    {
        // validation for constraint: string
        if (!is_null($purpose) && !is_string($purpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purpose, true), gettype($purpose)), __LINE__);
        }
        $this->Purpose = $purpose;
        return $this;
    }
    /**
     * Get TransferAmount value
     * @return float|null
     */
    public function getTransferAmount()
    {
        return $this->TransferAmount;
    }
    /**
     * Set TransferAmount value
     * @param float $transferAmount
     * @return \StructType\WsGatePass
     */
    public function setTransferAmount($transferAmount = null)
    {
        // validation for constraint: float
        if (!is_null($transferAmount) && !(is_float($transferAmount) || is_numeric($transferAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transferAmount, true), gettype($transferAmount)), __LINE__);
        }
        $this->TransferAmount = $transferAmount;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \StructType\WsGatePass
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \StructType\CustomFields|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \StructType\CustomFields $customFields
     * @return \StructType\WsGatePass
     */
    public function setCustomFields(\StructType\CustomFields $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WsGatePass
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
