<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vendor StructType
 * @subpackage Structs
 */
class Vendor extends AbstractStructBase
{
    /**
     * The VendorCode
     * @var string
     */
    public $VendorCode;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The PAN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PAN;
    /**
     * The TIN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TIN;
    /**
     * The CSTNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CSTNumber;
    /**
     * The STNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $STNumber;
    /**
     * The Website
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Website;
    /**
     * The PurchaseExpiryPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PurchaseExpiryPeriod;
    /**
     * The AcceptsCForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AcceptsCForm;
    /**
     * The RegisteredDealer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RegisteredDealer;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFields
     */
    public $CustomFields;
    /**
     * Constructor method for Vendor
     * @uses Vendor::setVendorCode()
     * @uses Vendor::setName()
     * @uses Vendor::setPAN()
     * @uses Vendor::setTIN()
     * @uses Vendor::setCSTNumber()
     * @uses Vendor::setSTNumber()
     * @uses Vendor::setWebsite()
     * @uses Vendor::setPurchaseExpiryPeriod()
     * @uses Vendor::setAcceptsCForm()
     * @uses Vendor::setRegisteredDealer()
     * @uses Vendor::setCustomFields()
     * @param string $vendorCode
     * @param string $name
     * @param string $pAN
     * @param string $tIN
     * @param string $cSTNumber
     * @param string $sTNumber
     * @param string $website
     * @param int $purchaseExpiryPeriod
     * @param int $acceptsCForm
     * @param bool $registeredDealer
     * @param \StructType\CustomFields $customFields
     */
    public function __construct($vendorCode = null, $name = null, $pAN = null, $tIN = null, $cSTNumber = null, $sTNumber = null, $website = null, $purchaseExpiryPeriod = null, $acceptsCForm = null, $registeredDealer = null, \StructType\CustomFields $customFields = null)
    {
        $this
            ->setVendorCode($vendorCode)
            ->setName($name)
            ->setPAN($pAN)
            ->setTIN($tIN)
            ->setCSTNumber($cSTNumber)
            ->setSTNumber($sTNumber)
            ->setWebsite($website)
            ->setPurchaseExpiryPeriod($purchaseExpiryPeriod)
            ->setAcceptsCForm($acceptsCForm)
            ->setRegisteredDealer($registeredDealer)
            ->setCustomFields($customFields);
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\Vendor
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode, true), gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Vendor
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PAN value
     * @return string|null
     */
    public function getPAN()
    {
        return $this->PAN;
    }
    /**
     * Set PAN value
     * @param string $pAN
     * @return \StructType\Vendor
     */
    public function setPAN($pAN = null)
    {
        // validation for constraint: string
        if (!is_null($pAN) && !is_string($pAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pAN, true), gettype($pAN)), __LINE__);
        }
        $this->PAN = $pAN;
        return $this;
    }
    /**
     * Get TIN value
     * @return string|null
     */
    public function getTIN()
    {
        return $this->TIN;
    }
    /**
     * Set TIN value
     * @param string $tIN
     * @return \StructType\Vendor
     */
    public function setTIN($tIN = null)
    {
        // validation for constraint: string
        if (!is_null($tIN) && !is_string($tIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tIN, true), gettype($tIN)), __LINE__);
        }
        $this->TIN = $tIN;
        return $this;
    }
    /**
     * Get CSTNumber value
     * @return string|null
     */
    public function getCSTNumber()
    {
        return $this->CSTNumber;
    }
    /**
     * Set CSTNumber value
     * @param string $cSTNumber
     * @return \StructType\Vendor
     */
    public function setCSTNumber($cSTNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cSTNumber) && !is_string($cSTNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cSTNumber, true), gettype($cSTNumber)), __LINE__);
        }
        $this->CSTNumber = $cSTNumber;
        return $this;
    }
    /**
     * Get STNumber value
     * @return string|null
     */
    public function getSTNumber()
    {
        return $this->STNumber;
    }
    /**
     * Set STNumber value
     * @param string $sTNumber
     * @return \StructType\Vendor
     */
    public function setSTNumber($sTNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sTNumber) && !is_string($sTNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sTNumber, true), gettype($sTNumber)), __LINE__);
        }
        $this->STNumber = $sTNumber;
        return $this;
    }
    /**
     * Get Website value
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->Website;
    }
    /**
     * Set Website value
     * @param string $website
     * @return \StructType\Vendor
     */
    public function setWebsite($website = null)
    {
        // validation for constraint: string
        if (!is_null($website) && !is_string($website)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($website, true), gettype($website)), __LINE__);
        }
        $this->Website = $website;
        return $this;
    }
    /**
     * Get PurchaseExpiryPeriod value
     * @return int|null
     */
    public function getPurchaseExpiryPeriod()
    {
        return $this->PurchaseExpiryPeriod;
    }
    /**
     * Set PurchaseExpiryPeriod value
     * @param int $purchaseExpiryPeriod
     * @return \StructType\Vendor
     */
    public function setPurchaseExpiryPeriod($purchaseExpiryPeriod = null)
    {
        // validation for constraint: int
        if (!is_null($purchaseExpiryPeriod) && !(is_int($purchaseExpiryPeriod) || ctype_digit($purchaseExpiryPeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($purchaseExpiryPeriod, true), gettype($purchaseExpiryPeriod)), __LINE__);
        }
        $this->PurchaseExpiryPeriod = $purchaseExpiryPeriod;
        return $this;
    }
    /**
     * Get AcceptsCForm value
     * @return int|null
     */
    public function getAcceptsCForm()
    {
        return $this->AcceptsCForm;
    }
    /**
     * Set AcceptsCForm value
     * @param int $acceptsCForm
     * @return \StructType\Vendor
     */
    public function setAcceptsCForm($acceptsCForm = null)
    {
        // validation for constraint: int
        if (!is_null($acceptsCForm) && !(is_int($acceptsCForm) || ctype_digit($acceptsCForm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($acceptsCForm, true), gettype($acceptsCForm)), __LINE__);
        }
        $this->AcceptsCForm = $acceptsCForm;
        return $this;
    }
    /**
     * Get RegisteredDealer value
     * @return bool|null
     */
    public function getRegisteredDealer()
    {
        return $this->RegisteredDealer;
    }
    /**
     * Set RegisteredDealer value
     * @param bool $registeredDealer
     * @return \StructType\Vendor
     */
    public function setRegisteredDealer($registeredDealer = null)
    {
        // validation for constraint: boolean
        if (!is_null($registeredDealer) && !is_bool($registeredDealer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($registeredDealer, true), gettype($registeredDealer)), __LINE__);
        }
        $this->RegisteredDealer = $registeredDealer;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \StructType\CustomFields|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \StructType\CustomFields $customFields
     * @return \StructType\Vendor
     */
    public function setCustomFields(\StructType\CustomFields $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Vendor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
