<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxTypeConfigurations StructType
 * @subpackage Structs
 */
class TaxTypeConfigurations extends AbstractStructBase
{
    /**
     * The TaxTypeConfiguration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxTypeConfiguration[]
     */
    public $TaxTypeConfiguration;
    /**
     * Constructor method for TaxTypeConfigurations
     * @uses TaxTypeConfigurations::setTaxTypeConfiguration()
     * @param \StructType\TaxTypeConfiguration[] $taxTypeConfiguration
     */
    public function __construct(array $taxTypeConfiguration = array())
    {
        $this
            ->setTaxTypeConfiguration($taxTypeConfiguration);
    }
    /**
     * Get TaxTypeConfiguration value
     * @return \StructType\TaxTypeConfiguration[]|null
     */
    public function getTaxTypeConfiguration()
    {
        return $this->TaxTypeConfiguration;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxTypeConfiguration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxTypeConfiguration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxTypeConfigurationForArrayConstraintsFromSetTaxTypeConfiguration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxTypeConfigurationsTaxTypeConfigurationItem) {
            // validation for constraint: itemType
            if (!$taxTypeConfigurationsTaxTypeConfigurationItem instanceof \StructType\TaxTypeConfiguration) {
                $invalidValues[] = is_object($taxTypeConfigurationsTaxTypeConfigurationItem) ? get_class($taxTypeConfigurationsTaxTypeConfigurationItem) : sprintf('%s(%s)', gettype($taxTypeConfigurationsTaxTypeConfigurationItem), var_export($taxTypeConfigurationsTaxTypeConfigurationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxTypeConfiguration property can only contain items of type \StructType\TaxTypeConfiguration, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxTypeConfiguration value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxTypeConfiguration[] $taxTypeConfiguration
     * @return \StructType\TaxTypeConfigurations
     */
    public function setTaxTypeConfiguration(array $taxTypeConfiguration = array())
    {
        // validation for constraint: array
        if ('' !== ($taxTypeConfigurationArrayErrorMessage = self::validateTaxTypeConfigurationForArrayConstraintsFromSetTaxTypeConfiguration($taxTypeConfiguration))) {
            throw new \InvalidArgumentException($taxTypeConfigurationArrayErrorMessage, __LINE__);
        }
        $this->TaxTypeConfiguration = $taxTypeConfiguration;
        return $this;
    }
    /**
     * Add item to TaxTypeConfiguration value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxTypeConfiguration $item
     * @return \StructType\TaxTypeConfigurations
     */
    public function addToTaxTypeConfiguration(\StructType\TaxTypeConfiguration $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxTypeConfiguration) {
            throw new \InvalidArgumentException(sprintf('The TaxTypeConfiguration property can only contain items of type \StructType\TaxTypeConfiguration, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxTypeConfiguration[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxTypeConfigurations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
