<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tags StructType
 * @subpackage Structs
 */
class Tags extends AbstractStructBase
{
    /**
     * The Tag
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $Tag;
    /**
     * Constructor method for Tags
     * @uses Tags::setTag()
     * @param mixed[] $tag
     */
    public function __construct(array $tag = array())
    {
        $this
            ->setTag($tag);
    }
    /**
     * Get Tag value
     * @return mixed[]|null
     */
    public function getTag()
    {
        return $this->Tag;
    }
    /**
     * This method is responsible for validating the values passed to the setTag method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTag method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTagForArrayConstraintsFromSetTag(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tagsTagItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($tagsTagItem) ? get_class($tagsTagItem) : sprintf('%s(%s)', gettype($tagsTagItem), var_export($tagsTagItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tag property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tag value
     * @throws \InvalidArgumentException
     * @param mixed[] $tag
     * @return \StructType\Tags
     */
    public function setTag(array $tag = array())
    {
        // validation for constraint: array
        if ('' !== ($tagArrayErrorMessage = self::validateTagForArrayConstraintsFromSetTag($tag))) {
            throw new \InvalidArgumentException($tagArrayErrorMessage, __LINE__);
        }
        $this->Tag = $tag;
        return $this;
    }
    /**
     * Add item to Tag value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Tags
     */
    public function addToTag($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Tag property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tag[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Tags
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
