<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingPackageType StructType
 * @subpackage Structs
 */
class ShippingPackageType extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The BoxLength
     * @var int
     */
    public $BoxLength;
    /**
     * The BoxWidth
     * @var int
     */
    public $BoxWidth;
    /**
     * The BoxHeight
     * @var int
     */
    public $BoxHeight;
    /**
     * The BoxWeight
     * @var int
     */
    public $BoxWeight;
    /**
     * Constructor method for ShippingPackageType
     * @uses ShippingPackageType::setCode()
     * @uses ShippingPackageType::setBoxLength()
     * @uses ShippingPackageType::setBoxWidth()
     * @uses ShippingPackageType::setBoxHeight()
     * @uses ShippingPackageType::setBoxWeight()
     * @param string $code
     * @param int $boxLength
     * @param int $boxWidth
     * @param int $boxHeight
     * @param int $boxWeight
     */
    public function __construct($code = null, $boxLength = null, $boxWidth = null, $boxHeight = null, $boxWeight = null)
    {
        $this
            ->setCode($code)
            ->setBoxLength($boxLength)
            ->setBoxWidth($boxWidth)
            ->setBoxHeight($boxHeight)
            ->setBoxWeight($boxWeight);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ShippingPackageType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get BoxLength value
     * @return int|null
     */
    public function getBoxLength()
    {
        return $this->BoxLength;
    }
    /**
     * Set BoxLength value
     * @param int $boxLength
     * @return \StructType\ShippingPackageType
     */
    public function setBoxLength($boxLength = null)
    {
        // validation for constraint: int
        if (!is_null($boxLength) && !(is_int($boxLength) || ctype_digit($boxLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($boxLength, true), gettype($boxLength)), __LINE__);
        }
        $this->BoxLength = $boxLength;
        return $this;
    }
    /**
     * Get BoxWidth value
     * @return int|null
     */
    public function getBoxWidth()
    {
        return $this->BoxWidth;
    }
    /**
     * Set BoxWidth value
     * @param int $boxWidth
     * @return \StructType\ShippingPackageType
     */
    public function setBoxWidth($boxWidth = null)
    {
        // validation for constraint: int
        if (!is_null($boxWidth) && !(is_int($boxWidth) || ctype_digit($boxWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($boxWidth, true), gettype($boxWidth)), __LINE__);
        }
        $this->BoxWidth = $boxWidth;
        return $this;
    }
    /**
     * Get BoxHeight value
     * @return int|null
     */
    public function getBoxHeight()
    {
        return $this->BoxHeight;
    }
    /**
     * Set BoxHeight value
     * @param int $boxHeight
     * @return \StructType\ShippingPackageType
     */
    public function setBoxHeight($boxHeight = null)
    {
        // validation for constraint: int
        if (!is_null($boxHeight) && !(is_int($boxHeight) || ctype_digit($boxHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($boxHeight, true), gettype($boxHeight)), __LINE__);
        }
        $this->BoxHeight = $boxHeight;
        return $this;
    }
    /**
     * Get BoxWeight value
     * @return int|null
     */
    public function getBoxWeight()
    {
        return $this->BoxWeight;
    }
    /**
     * Set BoxWeight value
     * @param int $boxWeight
     * @return \StructType\ShippingPackageType
     */
    public function setBoxWeight($boxWeight = null)
    {
        // validation for constraint: int
        if (!is_null($boxWeight) && !(is_int($boxWeight) || ctype_digit($boxWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($boxWeight, true), gettype($boxWeight)), __LINE__);
        }
        $this->BoxWeight = $boxWeight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShippingPackageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
