<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleOrderItemCombination StructType
 * @subpackage Structs
 */
class SaleOrderItemCombination extends AbstractStructBase
{
    /**
     * The Identifier
     * @var string
     */
    public $Identifier;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * Constructor method for SaleOrderItemCombination
     * @uses SaleOrderItemCombination::setIdentifier()
     * @uses SaleOrderItemCombination::setDescription()
     * @param string $identifier
     * @param string $description
     */
    public function __construct($identifier = null, $description = null)
    {
        $this
            ->setIdentifier($identifier)
            ->setDescription($description);
    }
    /**
     * Get Identifier value
     * @return string|null
     */
    public function getIdentifier()
    {
        return $this->Identifier;
    }
    /**
     * Set Identifier value
     * @param string $identifier
     * @return \StructType\SaleOrderItemCombination
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifier, true), gettype($identifier)), __LINE__);
        }
        $this->Identifier = $identifier;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\SaleOrderItemCombination
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaleOrderItemCombination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
