<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleOrderAddressItem StructType
 * @subpackage Structs
 */
class SaleOrderAddressItem extends AbstractStructBase
{
    /**
     * The SaleOrderItemCode
     * @var string
     */
    public $SaleOrderItemCode;
    /**
     * The ShippingAddress
     * @var \StructType\AddressRef
     */
    public $ShippingAddress;
    /**
     * Constructor method for SaleOrderAddressItem
     * @uses SaleOrderAddressItem::setSaleOrderItemCode()
     * @uses SaleOrderAddressItem::setShippingAddress()
     * @param string $saleOrderItemCode
     * @param \StructType\AddressRef $shippingAddress
     */
    public function __construct($saleOrderItemCode = null, \StructType\AddressRef $shippingAddress = null)
    {
        $this
            ->setSaleOrderItemCode($saleOrderItemCode)
            ->setShippingAddress($shippingAddress);
    }
    /**
     * Get SaleOrderItemCode value
     * @return string|null
     */
    public function getSaleOrderItemCode()
    {
        return $this->SaleOrderItemCode;
    }
    /**
     * Set SaleOrderItemCode value
     * @param string $saleOrderItemCode
     * @return \StructType\SaleOrderAddressItem
     */
    public function setSaleOrderItemCode($saleOrderItemCode = null)
    {
        // validation for constraint: string
        if (!is_null($saleOrderItemCode) && !is_string($saleOrderItemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOrderItemCode, true), gettype($saleOrderItemCode)), __LINE__);
        }
        $this->SaleOrderItemCode = $saleOrderItemCode;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \StructType\AddressRef|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \StructType\AddressRef $shippingAddress
     * @return \StructType\SaleOrderAddressItem
     */
    public function setShippingAddress(\StructType\AddressRef $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaleOrderAddressItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
