<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManifestItem StructType
 * @subpackage Structs
 */
class ManifestItem extends AbstractStructBase
{
    /**
     * The AirWayBillNumber
     * @var string
     */
    public $AirWayBillNumber;
    /**
     * The ShippingPackageCode
     * @var string
     */
    public $ShippingPackageCode;
    /**
     * The DisplayOrderCode
     * @var string
     */
    public $DisplayOrderCode;
    /**
     * The InvoiceCode
     * @var string
     */
    public $InvoiceCode;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The Weight
     * @var int
     */
    public $Weight;
    /**
     * The DeclaredValue
     * @var float
     */
    public $DeclaredValue;
    /**
     * The ShippingCharges
     * @var float
     */
    public $ShippingCharges;
    /**
     * The CollectableAmount
     * @var float
     */
    public $CollectableAmount;
    /**
     * The ShippingMethodCode
     * @var string
     */
    public $ShippingMethodCode;
    /**
     * The ShippingPackageType
     * @var \StructType\ShippingPackageType
     */
    public $ShippingPackageType;
    /**
     * The ShippingAddress
     * @var \StructType\ShippingAddress
     */
    public $ShippingAddress;
    /**
     * Constructor method for ManifestItem
     * @uses ManifestItem::setAirWayBillNumber()
     * @uses ManifestItem::setShippingPackageCode()
     * @uses ManifestItem::setDisplayOrderCode()
     * @uses ManifestItem::setInvoiceCode()
     * @uses ManifestItem::setQuantity()
     * @uses ManifestItem::setWeight()
     * @uses ManifestItem::setDeclaredValue()
     * @uses ManifestItem::setShippingCharges()
     * @uses ManifestItem::setCollectableAmount()
     * @uses ManifestItem::setShippingMethodCode()
     * @uses ManifestItem::setShippingPackageType()
     * @uses ManifestItem::setShippingAddress()
     * @param string $airWayBillNumber
     * @param string $shippingPackageCode
     * @param string $displayOrderCode
     * @param string $invoiceCode
     * @param int $quantity
     * @param int $weight
     * @param float $declaredValue
     * @param float $shippingCharges
     * @param float $collectableAmount
     * @param string $shippingMethodCode
     * @param \StructType\ShippingPackageType $shippingPackageType
     * @param \StructType\ShippingAddress $shippingAddress
     */
    public function __construct($airWayBillNumber = null, $shippingPackageCode = null, $displayOrderCode = null, $invoiceCode = null, $quantity = null, $weight = null, $declaredValue = null, $shippingCharges = null, $collectableAmount = null, $shippingMethodCode = null, \StructType\ShippingPackageType $shippingPackageType = null, \StructType\ShippingAddress $shippingAddress = null)
    {
        $this
            ->setAirWayBillNumber($airWayBillNumber)
            ->setShippingPackageCode($shippingPackageCode)
            ->setDisplayOrderCode($displayOrderCode)
            ->setInvoiceCode($invoiceCode)
            ->setQuantity($quantity)
            ->setWeight($weight)
            ->setDeclaredValue($declaredValue)
            ->setShippingCharges($shippingCharges)
            ->setCollectableAmount($collectableAmount)
            ->setShippingMethodCode($shippingMethodCode)
            ->setShippingPackageType($shippingPackageType)
            ->setShippingAddress($shippingAddress);
    }
    /**
     * Get AirWayBillNumber value
     * @return string|null
     */
    public function getAirWayBillNumber()
    {
        return $this->AirWayBillNumber;
    }
    /**
     * Set AirWayBillNumber value
     * @param string $airWayBillNumber
     * @return \StructType\ManifestItem
     */
    public function setAirWayBillNumber($airWayBillNumber = null)
    {
        // validation for constraint: string
        if (!is_null($airWayBillNumber) && !is_string($airWayBillNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airWayBillNumber, true), gettype($airWayBillNumber)), __LINE__);
        }
        $this->AirWayBillNumber = $airWayBillNumber;
        return $this;
    }
    /**
     * Get ShippingPackageCode value
     * @return string|null
     */
    public function getShippingPackageCode()
    {
        return $this->ShippingPackageCode;
    }
    /**
     * Set ShippingPackageCode value
     * @param string $shippingPackageCode
     * @return \StructType\ManifestItem
     */
    public function setShippingPackageCode($shippingPackageCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingPackageCode) && !is_string($shippingPackageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingPackageCode, true), gettype($shippingPackageCode)), __LINE__);
        }
        $this->ShippingPackageCode = $shippingPackageCode;
        return $this;
    }
    /**
     * Get DisplayOrderCode value
     * @return string|null
     */
    public function getDisplayOrderCode()
    {
        return $this->DisplayOrderCode;
    }
    /**
     * Set DisplayOrderCode value
     * @param string $displayOrderCode
     * @return \StructType\ManifestItem
     */
    public function setDisplayOrderCode($displayOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($displayOrderCode) && !is_string($displayOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayOrderCode, true), gettype($displayOrderCode)), __LINE__);
        }
        $this->DisplayOrderCode = $displayOrderCode;
        return $this;
    }
    /**
     * Get InvoiceCode value
     * @return string|null
     */
    public function getInvoiceCode()
    {
        return $this->InvoiceCode;
    }
    /**
     * Set InvoiceCode value
     * @param string $invoiceCode
     * @return \StructType\ManifestItem
     */
    public function setInvoiceCode($invoiceCode = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceCode) && !is_string($invoiceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceCode, true), gettype($invoiceCode)), __LINE__);
        }
        $this->InvoiceCode = $invoiceCode;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\ManifestItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param int $weight
     * @return \StructType\ManifestItem
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !(is_int($weight) || ctype_digit($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get DeclaredValue value
     * @return float|null
     */
    public function getDeclaredValue()
    {
        return $this->DeclaredValue;
    }
    /**
     * Set DeclaredValue value
     * @param float $declaredValue
     * @return \StructType\ManifestItem
     */
    public function setDeclaredValue($declaredValue = null)
    {
        // validation for constraint: float
        if (!is_null($declaredValue) && !(is_float($declaredValue) || is_numeric($declaredValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($declaredValue, true), gettype($declaredValue)), __LINE__);
        }
        $this->DeclaredValue = $declaredValue;
        return $this;
    }
    /**
     * Get ShippingCharges value
     * @return float|null
     */
    public function getShippingCharges()
    {
        return $this->ShippingCharges;
    }
    /**
     * Set ShippingCharges value
     * @param float $shippingCharges
     * @return \StructType\ManifestItem
     */
    public function setShippingCharges($shippingCharges = null)
    {
        // validation for constraint: float
        if (!is_null($shippingCharges) && !(is_float($shippingCharges) || is_numeric($shippingCharges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shippingCharges, true), gettype($shippingCharges)), __LINE__);
        }
        $this->ShippingCharges = $shippingCharges;
        return $this;
    }
    /**
     * Get CollectableAmount value
     * @return float|null
     */
    public function getCollectableAmount()
    {
        return $this->CollectableAmount;
    }
    /**
     * Set CollectableAmount value
     * @param float $collectableAmount
     * @return \StructType\ManifestItem
     */
    public function setCollectableAmount($collectableAmount = null)
    {
        // validation for constraint: float
        if (!is_null($collectableAmount) && !(is_float($collectableAmount) || is_numeric($collectableAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($collectableAmount, true), gettype($collectableAmount)), __LINE__);
        }
        $this->CollectableAmount = $collectableAmount;
        return $this;
    }
    /**
     * Get ShippingMethodCode value
     * @return string|null
     */
    public function getShippingMethodCode()
    {
        return $this->ShippingMethodCode;
    }
    /**
     * Set ShippingMethodCode value
     * @param string $shippingMethodCode
     * @return \StructType\ManifestItem
     */
    public function setShippingMethodCode($shippingMethodCode = null)
    {
        // validation for constraint: string
        if (!is_null($shippingMethodCode) && !is_string($shippingMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingMethodCode, true), gettype($shippingMethodCode)), __LINE__);
        }
        $this->ShippingMethodCode = $shippingMethodCode;
        return $this;
    }
    /**
     * Get ShippingPackageType value
     * @return \StructType\ShippingPackageType|null
     */
    public function getShippingPackageType()
    {
        return $this->ShippingPackageType;
    }
    /**
     * Set ShippingPackageType value
     * @param \StructType\ShippingPackageType $shippingPackageType
     * @return \StructType\ManifestItem
     */
    public function setShippingPackageType(\StructType\ShippingPackageType $shippingPackageType = null)
    {
        $this->ShippingPackageType = $shippingPackageType;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \StructType\ShippingAddress|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \StructType\ShippingAddress $shippingAddress
     * @return \StructType\ManifestItem
     */
    public function setShippingAddress(\StructType\ShippingAddress $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ManifestItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
