<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemTypeRequest StructType
 * @subpackage Structs
 */
class ItemTypeRequest extends AbstractStructBase
{
    /**
     * The CategoryCode
     * @var string
     */
    public $CategoryCode;
    /**
     * The ItemSKU
     * @var string
     */
    public $ItemSKU;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ScanIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ScanIdentifier;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Length;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Width;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Height;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Weight;
    /**
     * The MinOrderSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinOrderSize;
    /**
     * The Color
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Color;
    /**
     * The Brand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Brand;
    /**
     * The Size
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Size;
    /**
     * The MRP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MRP;
    /**
     * The TaxTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TaxTypeCode;
    /**
     * The Features
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Features;
    /**
     * The ImageURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImageURL;
    /**
     * The ProductPageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProductPageUrl;
    /**
     * The RequiresCustomization
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RequiresCustomization;
    /**
     * The ItemDetailFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ItemDetailFields;
    /**
     * The Tags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Tags
     */
    public $Tags;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFields
     */
    public $CustomFields;
    /**
     * Constructor method for ItemTypeRequest
     * @uses ItemTypeRequest::setCategoryCode()
     * @uses ItemTypeRequest::setItemSKU()
     * @uses ItemTypeRequest::setName()
     * @uses ItemTypeRequest::setDescription()
     * @uses ItemTypeRequest::setScanIdentifier()
     * @uses ItemTypeRequest::setLength()
     * @uses ItemTypeRequest::setWidth()
     * @uses ItemTypeRequest::setHeight()
     * @uses ItemTypeRequest::setWeight()
     * @uses ItemTypeRequest::setMinOrderSize()
     * @uses ItemTypeRequest::setColor()
     * @uses ItemTypeRequest::setBrand()
     * @uses ItemTypeRequest::setSize()
     * @uses ItemTypeRequest::setMRP()
     * @uses ItemTypeRequest::setTaxTypeCode()
     * @uses ItemTypeRequest::setFeatures()
     * @uses ItemTypeRequest::setImageURL()
     * @uses ItemTypeRequest::setProductPageUrl()
     * @uses ItemTypeRequest::setRequiresCustomization()
     * @uses ItemTypeRequest::setItemDetailFields()
     * @uses ItemTypeRequest::setTags()
     * @uses ItemTypeRequest::setCustomFields()
     * @param string $categoryCode
     * @param string $itemSKU
     * @param string $name
     * @param string $description
     * @param string $scanIdentifier
     * @param int $length
     * @param int $width
     * @param int $height
     * @param int $weight
     * @param int $minOrderSize
     * @param string $color
     * @param string $brand
     * @param string $size
     * @param float $mRP
     * @param string $taxTypeCode
     * @param string $features
     * @param string $imageURL
     * @param string $productPageUrl
     * @param bool $requiresCustomization
     * @param string $itemDetailFields
     * @param \StructType\Tags $tags
     * @param \StructType\CustomFields $customFields
     */
    public function __construct($categoryCode = null, $itemSKU = null, $name = null, $description = null, $scanIdentifier = null, $length = null, $width = null, $height = null, $weight = null, $minOrderSize = null, $color = null, $brand = null, $size = null, $mRP = null, $taxTypeCode = null, $features = null, $imageURL = null, $productPageUrl = null, $requiresCustomization = null, $itemDetailFields = null, \StructType\Tags $tags = null, \StructType\CustomFields $customFields = null)
    {
        $this
            ->setCategoryCode($categoryCode)
            ->setItemSKU($itemSKU)
            ->setName($name)
            ->setDescription($description)
            ->setScanIdentifier($scanIdentifier)
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height)
            ->setWeight($weight)
            ->setMinOrderSize($minOrderSize)
            ->setColor($color)
            ->setBrand($brand)
            ->setSize($size)
            ->setMRP($mRP)
            ->setTaxTypeCode($taxTypeCode)
            ->setFeatures($features)
            ->setImageURL($imageURL)
            ->setProductPageUrl($productPageUrl)
            ->setRequiresCustomization($requiresCustomization)
            ->setItemDetailFields($itemDetailFields)
            ->setTags($tags)
            ->setCustomFields($customFields);
    }
    /**
     * Get CategoryCode value
     * @return string|null
     */
    public function getCategoryCode()
    {
        return $this->CategoryCode;
    }
    /**
     * Set CategoryCode value
     * @param string $categoryCode
     * @return \StructType\ItemTypeRequest
     */
    public function setCategoryCode($categoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($categoryCode) && !is_string($categoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryCode, true), gettype($categoryCode)), __LINE__);
        }
        $this->CategoryCode = $categoryCode;
        return $this;
    }
    /**
     * Get ItemSKU value
     * @return string|null
     */
    public function getItemSKU()
    {
        return $this->ItemSKU;
    }
    /**
     * Set ItemSKU value
     * @param string $itemSKU
     * @return \StructType\ItemTypeRequest
     */
    public function setItemSKU($itemSKU = null)
    {
        // validation for constraint: string
        if (!is_null($itemSKU) && !is_string($itemSKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemSKU, true), gettype($itemSKU)), __LINE__);
        }
        $this->ItemSKU = $itemSKU;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ItemTypeRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ItemTypeRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ScanIdentifier value
     * @return string|null
     */
    public function getScanIdentifier()
    {
        return $this->ScanIdentifier;
    }
    /**
     * Set ScanIdentifier value
     * @param string $scanIdentifier
     * @return \StructType\ItemTypeRequest
     */
    public function setScanIdentifier($scanIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($scanIdentifier) && !is_string($scanIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanIdentifier, true), gettype($scanIdentifier)), __LINE__);
        }
        $this->ScanIdentifier = $scanIdentifier;
        return $this;
    }
    /**
     * Get Length value
     * @return int|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param int $length
     * @return \StructType\ItemTypeRequest
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !(is_int($length) || ctype_digit($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param int $width
     * @return \StructType\ItemTypeRequest
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !(is_int($width) || ctype_digit($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param int $height
     * @return \StructType\ItemTypeRequest
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !(is_int($height) || ctype_digit($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param int $weight
     * @return \StructType\ItemTypeRequest
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !(is_int($weight) || ctype_digit($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get MinOrderSize value
     * @return int|null
     */
    public function getMinOrderSize()
    {
        return $this->MinOrderSize;
    }
    /**
     * Set MinOrderSize value
     * @param int $minOrderSize
     * @return \StructType\ItemTypeRequest
     */
    public function setMinOrderSize($minOrderSize = null)
    {
        // validation for constraint: int
        if (!is_null($minOrderSize) && !(is_int($minOrderSize) || ctype_digit($minOrderSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minOrderSize, true), gettype($minOrderSize)), __LINE__);
        }
        $this->MinOrderSize = $minOrderSize;
        return $this;
    }
    /**
     * Get Color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @param string $color
     * @return \StructType\ItemTypeRequest
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        $this->Color = $color;
        return $this;
    }
    /**
     * Get Brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param string $brand
     * @return \StructType\ItemTypeRequest
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Get Size value
     * @return string|null
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param string $size
     * @return \StructType\ItemTypeRequest
     */
    public function setSize($size = null)
    {
        // validation for constraint: string
        if (!is_null($size) && !is_string($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->Size = $size;
        return $this;
    }
    /**
     * Get MRP value
     * @return float|null
     */
    public function getMRP()
    {
        return $this->MRP;
    }
    /**
     * Set MRP value
     * @param float $mRP
     * @return \StructType\ItemTypeRequest
     */
    public function setMRP($mRP = null)
    {
        // validation for constraint: float
        if (!is_null($mRP) && !(is_float($mRP) || is_numeric($mRP))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mRP, true), gettype($mRP)), __LINE__);
        }
        $this->MRP = $mRP;
        return $this;
    }
    /**
     * Get TaxTypeCode value
     * @return string|null
     */
    public function getTaxTypeCode()
    {
        return $this->TaxTypeCode;
    }
    /**
     * Set TaxTypeCode value
     * @param string $taxTypeCode
     * @return \StructType\ItemTypeRequest
     */
    public function setTaxTypeCode($taxTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxTypeCode) && !is_string($taxTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxTypeCode, true), gettype($taxTypeCode)), __LINE__);
        }
        $this->TaxTypeCode = $taxTypeCode;
        return $this;
    }
    /**
     * Get Features value
     * @return string|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * Set Features value
     * @param string $features
     * @return \StructType\ItemTypeRequest
     */
    public function setFeatures($features = null)
    {
        // validation for constraint: string
        if (!is_null($features) && !is_string($features)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($features, true), gettype($features)), __LINE__);
        }
        $this->Features = $features;
        return $this;
    }
    /**
     * Get ImageURL value
     * @return string|null
     */
    public function getImageURL()
    {
        return $this->ImageURL;
    }
    /**
     * Set ImageURL value
     * @param string $imageURL
     * @return \StructType\ItemTypeRequest
     */
    public function setImageURL($imageURL = null)
    {
        // validation for constraint: string
        if (!is_null($imageURL) && !is_string($imageURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageURL, true), gettype($imageURL)), __LINE__);
        }
        $this->ImageURL = $imageURL;
        return $this;
    }
    /**
     * Get ProductPageUrl value
     * @return string|null
     */
    public function getProductPageUrl()
    {
        return $this->ProductPageUrl;
    }
    /**
     * Set ProductPageUrl value
     * @param string $productPageUrl
     * @return \StructType\ItemTypeRequest
     */
    public function setProductPageUrl($productPageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($productPageUrl) && !is_string($productPageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productPageUrl, true), gettype($productPageUrl)), __LINE__);
        }
        $this->ProductPageUrl = $productPageUrl;
        return $this;
    }
    /**
     * Get RequiresCustomization value
     * @return bool|null
     */
    public function getRequiresCustomization()
    {
        return $this->RequiresCustomization;
    }
    /**
     * Set RequiresCustomization value
     * @param bool $requiresCustomization
     * @return \StructType\ItemTypeRequest
     */
    public function setRequiresCustomization($requiresCustomization = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiresCustomization) && !is_bool($requiresCustomization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requiresCustomization, true), gettype($requiresCustomization)), __LINE__);
        }
        $this->RequiresCustomization = $requiresCustomization;
        return $this;
    }
    /**
     * Get ItemDetailFields value
     * @return string|null
     */
    public function getItemDetailFields()
    {
        return $this->ItemDetailFields;
    }
    /**
     * Set ItemDetailFields value
     * @param string $itemDetailFields
     * @return \StructType\ItemTypeRequest
     */
    public function setItemDetailFields($itemDetailFields = null)
    {
        // validation for constraint: string
        if (!is_null($itemDetailFields) && !is_string($itemDetailFields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDetailFields, true), gettype($itemDetailFields)), __LINE__);
        }
        $this->ItemDetailFields = $itemDetailFields;
        return $this;
    }
    /**
     * Get Tags value
     * @return \StructType\Tags|null
     */
    public function getTags()
    {
        return $this->Tags;
    }
    /**
     * Set Tags value
     * @param \StructType\Tags $tags
     * @return \StructType\ItemTypeRequest
     */
    public function setTags(\StructType\Tags $tags = null)
    {
        $this->Tags = $tags;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \StructType\CustomFields|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \StructType\CustomFields $customFields
     * @return \StructType\ItemTypeRequest
     */
    public function setCustomFields(\StructType\CustomFields $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemTypeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
