<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemTypeInventoryDetails StructType
 * @subpackage Structs
 */
class ItemTypeInventoryDetails extends AbstractStructBase
{
    /**
     * The ItemTypeInventory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemTypeInventory[]
     */
    public $ItemTypeInventory;
    /**
     * Constructor method for ItemTypeInventoryDetails
     * @uses ItemTypeInventoryDetails::setItemTypeInventory()
     * @param \StructType\ItemTypeInventory[] $itemTypeInventory
     */
    public function __construct(array $itemTypeInventory = array())
    {
        $this
            ->setItemTypeInventory($itemTypeInventory);
    }
    /**
     * Get ItemTypeInventory value
     * @return \StructType\ItemTypeInventory[]|null
     */
    public function getItemTypeInventory()
    {
        return $this->ItemTypeInventory;
    }
    /**
     * This method is responsible for validating the values passed to the setItemTypeInventory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemTypeInventory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemTypeInventoryForArrayConstraintsFromSetItemTypeInventory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemTypeInventoryDetailsItemTypeInventoryItem) {
            // validation for constraint: itemType
            if (!$itemTypeInventoryDetailsItemTypeInventoryItem instanceof \StructType\ItemTypeInventory) {
                $invalidValues[] = is_object($itemTypeInventoryDetailsItemTypeInventoryItem) ? get_class($itemTypeInventoryDetailsItemTypeInventoryItem) : sprintf('%s(%s)', gettype($itemTypeInventoryDetailsItemTypeInventoryItem), var_export($itemTypeInventoryDetailsItemTypeInventoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemTypeInventory property can only contain items of type \StructType\ItemTypeInventory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemTypeInventory value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemTypeInventory[] $itemTypeInventory
     * @return \StructType\ItemTypeInventoryDetails
     */
    public function setItemTypeInventory(array $itemTypeInventory = array())
    {
        // validation for constraint: array
        if ('' !== ($itemTypeInventoryArrayErrorMessage = self::validateItemTypeInventoryForArrayConstraintsFromSetItemTypeInventory($itemTypeInventory))) {
            throw new \InvalidArgumentException($itemTypeInventoryArrayErrorMessage, __LINE__);
        }
        $this->ItemTypeInventory = $itemTypeInventory;
        return $this;
    }
    /**
     * Add item to ItemTypeInventory value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemTypeInventory $item
     * @return \StructType\ItemTypeInventoryDetails
     */
    public function addToItemTypeInventory(\StructType\ItemTypeInventory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemTypeInventory) {
            throw new \InvalidArgumentException(sprintf('The ItemTypeInventory property can only contain items of type \StructType\ItemTypeInventory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemTypeInventory[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemTypeInventoryDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
