<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemTypeInventory StructType
 * @subpackage Structs
 */
class ItemTypeInventory extends AbstractStructBase
{
    /**
     * The Shelf
     * @var string
     */
    public $Shelf;
    /**
     * The ItemTypeName
     * @var string
     */
    public $ItemTypeName;
    /**
     * The ImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImageUrl;
    /**
     * The ProductPageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProductPageUrl;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The MRP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MRP;
    /**
     * The QuantityInPicking
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $QuantityInPicking;
    /**
     * The FacilityCode
     * @var string
     */
    public $FacilityCode;
    /**
     * The FacilityName
     * @var string
     */
    public $FacilityName;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for ItemTypeInventory
     * @uses ItemTypeInventory::setShelf()
     * @uses ItemTypeInventory::setItemTypeName()
     * @uses ItemTypeInventory::setImageUrl()
     * @uses ItemTypeInventory::setProductPageUrl()
     * @uses ItemTypeInventory::setQuantity()
     * @uses ItemTypeInventory::setMRP()
     * @uses ItemTypeInventory::setQuantityInPicking()
     * @uses ItemTypeInventory::setFacilityCode()
     * @uses ItemTypeInventory::setFacilityName()
     * @uses ItemTypeInventory::setType()
     * @param string $shelf
     * @param string $itemTypeName
     * @param string $imageUrl
     * @param string $productPageUrl
     * @param int $quantity
     * @param int $mRP
     * @param int $quantityInPicking
     * @param string $facilityCode
     * @param string $facilityName
     * @param string $type
     */
    public function __construct($shelf = null, $itemTypeName = null, $imageUrl = null, $productPageUrl = null, $quantity = null, $mRP = null, $quantityInPicking = null, $facilityCode = null, $facilityName = null, $type = null)
    {
        $this
            ->setShelf($shelf)
            ->setItemTypeName($itemTypeName)
            ->setImageUrl($imageUrl)
            ->setProductPageUrl($productPageUrl)
            ->setQuantity($quantity)
            ->setMRP($mRP)
            ->setQuantityInPicking($quantityInPicking)
            ->setFacilityCode($facilityCode)
            ->setFacilityName($facilityName)
            ->setType($type);
    }
    /**
     * Get Shelf value
     * @return string|null
     */
    public function getShelf()
    {
        return $this->Shelf;
    }
    /**
     * Set Shelf value
     * @param string $shelf
     * @return \StructType\ItemTypeInventory
     */
    public function setShelf($shelf = null)
    {
        // validation for constraint: string
        if (!is_null($shelf) && !is_string($shelf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shelf, true), gettype($shelf)), __LINE__);
        }
        $this->Shelf = $shelf;
        return $this;
    }
    /**
     * Get ItemTypeName value
     * @return string|null
     */
    public function getItemTypeName()
    {
        return $this->ItemTypeName;
    }
    /**
     * Set ItemTypeName value
     * @param string $itemTypeName
     * @return \StructType\ItemTypeInventory
     */
    public function setItemTypeName($itemTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($itemTypeName) && !is_string($itemTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemTypeName, true), gettype($itemTypeName)), __LINE__);
        }
        $this->ItemTypeName = $itemTypeName;
        return $this;
    }
    /**
     * Get ImageUrl value
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->ImageUrl;
    }
    /**
     * Set ImageUrl value
     * @param string $imageUrl
     * @return \StructType\ItemTypeInventory
     */
    public function setImageUrl($imageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($imageUrl) && !is_string($imageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageUrl, true), gettype($imageUrl)), __LINE__);
        }
        $this->ImageUrl = $imageUrl;
        return $this;
    }
    /**
     * Get ProductPageUrl value
     * @return string|null
     */
    public function getProductPageUrl()
    {
        return $this->ProductPageUrl;
    }
    /**
     * Set ProductPageUrl value
     * @param string $productPageUrl
     * @return \StructType\ItemTypeInventory
     */
    public function setProductPageUrl($productPageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($productPageUrl) && !is_string($productPageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productPageUrl, true), gettype($productPageUrl)), __LINE__);
        }
        $this->ProductPageUrl = $productPageUrl;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\ItemTypeInventory
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get MRP value
     * @return int|null
     */
    public function getMRP()
    {
        return $this->MRP;
    }
    /**
     * Set MRP value
     * @param int $mRP
     * @return \StructType\ItemTypeInventory
     */
    public function setMRP($mRP = null)
    {
        // validation for constraint: int
        if (!is_null($mRP) && !(is_int($mRP) || ctype_digit($mRP))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mRP, true), gettype($mRP)), __LINE__);
        }
        $this->MRP = $mRP;
        return $this;
    }
    /**
     * Get QuantityInPicking value
     * @return int|null
     */
    public function getQuantityInPicking()
    {
        return $this->QuantityInPicking;
    }
    /**
     * Set QuantityInPicking value
     * @param int $quantityInPicking
     * @return \StructType\ItemTypeInventory
     */
    public function setQuantityInPicking($quantityInPicking = null)
    {
        // validation for constraint: int
        if (!is_null($quantityInPicking) && !(is_int($quantityInPicking) || ctype_digit($quantityInPicking))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityInPicking, true), gettype($quantityInPicking)), __LINE__);
        }
        $this->QuantityInPicking = $quantityInPicking;
        return $this;
    }
    /**
     * Get FacilityCode value
     * @return string|null
     */
    public function getFacilityCode()
    {
        return $this->FacilityCode;
    }
    /**
     * Set FacilityCode value
     * @param string $facilityCode
     * @return \StructType\ItemTypeInventory
     */
    public function setFacilityCode($facilityCode = null)
    {
        // validation for constraint: string
        if (!is_null($facilityCode) && !is_string($facilityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facilityCode, true), gettype($facilityCode)), __LINE__);
        }
        $this->FacilityCode = $facilityCode;
        return $this;
    }
    /**
     * Get FacilityName value
     * @return string|null
     */
    public function getFacilityName()
    {
        return $this->FacilityName;
    }
    /**
     * Set FacilityName value
     * @param string $facilityName
     * @return \StructType\ItemTypeInventory
     */
    public function setFacilityName($facilityName = null)
    {
        // validation for constraint: string
        if (!is_null($facilityName) && !is_string($facilityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facilityName, true), gettype($facilityName)), __LINE__);
        }
        $this->FacilityName = $facilityName;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\ItemTypeInventory
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemTypeInventory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
