<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemCodes StructType
 * @subpackage Structs
 */
class ItemCodes extends AbstractStructBase
{
    /**
     * The ItemCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $ItemCode;
    /**
     * Constructor method for ItemCodes
     * @uses ItemCodes::setItemCode()
     * @param string[] $itemCode
     */
    public function __construct(array $itemCode = array())
    {
        $this
            ->setItemCode($itemCode);
    }
    /**
     * Get ItemCode value
     * @return string[]|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * This method is responsible for validating the values passed to the setItemCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemCodeForArrayConstraintsFromSetItemCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemCodesItemCodeItem) {
            // validation for constraint: itemType
            if (!is_string($itemCodesItemCodeItem)) {
                $invalidValues[] = is_object($itemCodesItemCodeItem) ? get_class($itemCodesItemCodeItem) : sprintf('%s(%s)', gettype($itemCodesItemCodeItem), var_export($itemCodesItemCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemCode value
     * @throws \InvalidArgumentException
     * @param string[] $itemCode
     * @return \StructType\ItemCodes
     */
    public function setItemCode(array $itemCode = array())
    {
        // validation for constraint: array
        if ('' !== ($itemCodeArrayErrorMessage = self::validateItemCodeForArrayConstraintsFromSetItemCode($itemCode))) {
            throw new \InvalidArgumentException($itemCodeArrayErrorMessage, __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Add item to ItemCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ItemCodes
     */
    public function addToItemCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ItemCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
